% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{wem}
\alias{wem}
\title{Generalized version of \code{\link{uni_em}}.}
\usage{
wem(weight_vec, lmat, pi_init, lambda, itermax, obj_tol)
}
\arguments{
\item{weight_vec}{A vector of weights. Each element of \code{weight_vec} corresponds
to a column of \code{lmat}.}

\item{lmat}{A matrix of inner weights. The columns are the "individuals" and the rows are the "classes."}

\item{pi_init}{The initial values of \code{pivec}. Each element of \code{pi_init}
corresponds to a row of \code{lmat}.}

\item{lambda}{The penalty on the pi's. Should be greater than 0 and really really small.}

\item{itermax}{The maximum number of EM iterations to take.}

\item{obj_tol}{The objective stopping criterion.}
}
\value{
A vector of numerics. The update of \code{pivec} in
    \code{\link{flexdog_full}}.
}
\description{
Generalized version of \code{\link{uni_em}}.
}
\examples{
set.seed(2)
n <- 3
p <- 5
lmat <- matrix(stats::runif(n * p), nrow = n)
weight_vec <- seq_len(p)
pi_init <- stats::runif(n)
pi_init <- pi_init / sum(pi_init)
wem(weight_vec = weight_vec,
    lmat       = lmat,
    pi_init    = pi_init,
    lambda     = 0,
    itermax    = 100,
    obj_tol    = 10^-6)

}
\seealso{
\code{\link{uni_em}} for a description of the
    optimization problem.
}
\author{
David Gerard
}
