% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{units_options}
\alias{units_options}
\title{set one or more units global options}
\usage{
units_options(..., sep, group, negative_power, parse, set_units_mode,
  auto_convert_names_to_symbols)
}
\arguments{
\item{...}{ignored}

\item{sep}{character length two; default \code{c("~", "~")}; space separator between variable and units, and space separator between two different units}

\item{group}{character length two; start and end group, may be two empty strings, a parenthesis pair, or square brackets.}

\item{negative_power}{logical, default FALSE; should denominators have negative power, or follow a division symbol?}

\item{parse}{logical, default \code{TRUE}; should the units be made into an expression (so we get subscripts)? Setting to \code{FALSE} may be useful if \link{parse} fails, e.g. if the unit contains symbols that assume a particular encoding}

\item{set_units_mode}{character; either \code{"symbols"} or \code{"standard"}; see \link{set_units}}

\item{auto_convert_names_to_symbols}{logical: should names, such as \code{degree_C} be converted to their usual symbol?}
}
\description{
set units global options, mostly related how units are printed and plotted
}
\examples{
units_options(sep = c("~~~", "~"), group = c("", "")) # more space, parenthesis
## set defaults:
units_options(sep = c("~", "~"), group = c("[", "]"), negative_power = FALSE, parse = TRUE)
}
