% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_demo.R
\name{demopal}
\alias{demopal}
\alias{democol}
\alias{demofun}
\alias{demoplot}
\title{Demonstrate a color palette.}
\usage{
demopal(pal = pal_unikn, type = NA, pal_name = NULL, ...)
}
\arguments{
\item{pal}{A color palette (to be illustrated).
Default: \code{pal = pal_unikn}.}

\item{type}{The type of plot to be used (as character string or integer value). 
Permissible types are 
\code{"bar"}, \code{"curve"}, \code{"mosaic"}, \code{"polygon"}, or \code{"scatter"} 
(or an integer value from 1 to 5, respectively).}

\item{pal_name}{A name for the input color palette \code{pal} (shown on bottom-right margin). 
Default: \code{pal_name = NULL} (deparsing to input name).}

\item{...}{Auxiliary arguments passed to \code{type}-specific plots (see details).}
}
\value{
The random data that was plotted (as an invisible R object).
}
\description{
\code{demopal} provides an example plot of some \code{type} 
to illustrate a color palette \code{pal}.
}
\details{
The \code{demopal} wrapper function passes a range of arguments to more specific functions. 
Common arguments include:

\itemize{

  \item \code{col_par} Default color for \code{par(col)}; 
  \item \code{alpha} Default value for color transparency (in 0:1);  
  \item \code{n} A scaling parameter (for random data generation);  

  \item \code{main} plot title (on top); 
  \item \code{sub} plot subtitle (on right margin);  
  
  \item \code{seed} A random seed value (for reproducible randomness). 
  
}

The fit between a color palette \code{pal} and plot \code{type} 
depends on the uses of colors in a plot. 
For instance, overlaps of transparent color areas can be evaluated 
with plot \code{type = "curve"} or plot \code{type = "scatter"} 
(and \code{0 < alpha < 1}). 

Some functions additionally accept type-specific arguments 
(e.g., \code{beside}, \code{horiz}, and \code{as_prop}, for plot \code{type = "bar"}, 
and \code{cex} for plot \code{type = "scatter"}). 

The type-specific functions usually generate some random data 
(scaled by a parameter \code{n}) that is being plotted. 
This data is returned (as an invisible R object)  
to enable a plot's reconstruction.
}
\examples{
demopal(pal = pal_petrol, type = 1)

my_pal <- c(rev(pal_pinky), pal_seeblau) 
# Selecting plot type:
demopal(my_pal, type = 2)          # by numeric index
demopal(my_pal, type = "polygon")  # by name

# Passing type-specific arguments:
demopal(type = "scatter", col_par = "black", n = 200, cex = c(2, 4, 6), seed = 101)

}
\seealso{
\code{\link{seepal}} for plotting color palettes;  
\code{\link{usecol}} for using color palettes; 
\code{\link{shades_of}} to defining shades of a given color; 
\code{\link{ac}} for adjusting color transparency; 
\code{\link{pal_unikn}} for the default uni.kn color palette.

Other color functions: 
\code{\link{ac}()},
\code{\link{grepal}()},
\code{\link{newpal}()},
\code{\link{seecol}()},
\code{\link{shades_of}()},
\code{\link{simcol}()},
\code{\link{usecol}()}
}
\concept{color functions}
