% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volumes.R
\name{volume_ellipsoid}
\alias{volume_ellipsoid}
\title{Ellipsoid volume}
\usage{
volume_ellipsoid(A, r)
}
\arguments{
\item{A}{symmetric positive-definite matrix defining the ellipsoid (see
Details)}

\item{r}{"radius" (see Details)}
}
\value{
The volume of the ellipsoid.
}
\description{
Volume of an ellipsoid (arbitrary dimension).
}
\details{
The (boundary of the) ellipsoid is the set of vectors \code{x}
satisfying \code{t(x) \%*\% A \%*\% x == r^2}.
}
\examples{
# dimension 2 (area), with diagonal matrix A
A <- diag(c(2,3))
r <- 2
volume_ellipsoid(A, r)
pi * r^2 / sqrt(A[1,1]*A[2,2])
}
