% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Kiel.R
\docType{data}
\name{uni_kiel_1}
\alias{uni_kiel_1}
\title{Primary color of Kiel University, Germany}
\format{
An object of class \code{character} of length 3.
}
\source{
Color definitions are based on 
\url{https://www.presse.uni-kiel.de/de/erscheinungsbild/farben}.
}
\usage{
uni_kiel_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_kiel_1} provides the primary \code{violett} color
of \href{https://www.uni-kiel.de/en/}{Kiel University}, Germany.
}
\details{
The main color is the luminant \code{violett} of \code{uni_kiel_1[2]}, 
which alludes to the historic founding faculty of theology. 
It is alternatively defined as \code{RGB 155/10/125}, \code{Hex #9b0a7d}, 
\code{HKS 33}, or \code{CMYK 45/100/0/0}. 

The palette \code{uni_kiel_1} enframes this color as its central element 
in \code{"black"} and \code{"white"} to easily enable mixing it with 
shades of \code{"grey"}. 
See examples and the \code{\link{ac}} and \code{\link{usecol}} functions 
for creating color gradients. 

The full name of \href{https://www.uni-kiel.de/en/}{Kiel University} 
is Christian-Albrechts-Universität (CAU) zu Kiel.
}
\examples{
uni_kiel_1
unikn::seecol(uni_kiel_1, main = "The main color of Kiel University (CAU)")
unikn::demopal(uni_kiel_1, type = 3, main = "Primary colors of the University of Kiel")

# Gradient: Mixing the main color with shades of grey: 
N = 9
kiel_mix <- unikn::usecol(uni_kiel_1, n = N)[c(-1, -N)]  # remove extremes
unikn::seecol(kiel_mix, main = "A color gradient of Kiel University (CAU)")

}
\seealso{
\code{\link{uni_kiel_2}} for departmental colors of Kiel University;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0}},
\code{\link{fu_1}},
\code{\link{fu_2}},
\code{\link{fu_3}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2023-01-02.
}
\concept{German university color palettes}
\keyword{datasets}
