% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Freiburg.R
\docType{data}
\name{uni_freiburg_grey}
\alias{uni_freiburg_grey}
\title{Grey colors of the University of Freiburg, Germany (2022)}
\format{
An object of class \code{character} of length 8.
}
\source{
Color definitions are based on the web style guide at 
\url{https://uni-freiburg.de/} 
(at \code{portal.uni-freiburg.de/cmsforum/wsg/webstyleguide/farben} on 2022-10-20).
}
\usage{
uni_freiburg_grey
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_freiburg_grey} provides the grey colors 
of the \href{https://uni-freiburg.de/}{University of Freiburg}, Germany.
}
\details{
\strong{Please note}: 
See \code{\link{uni_freiburg_0}} and \code{\link{uni_freiburg_1}}  
for the corresponding colors of the new corporate design (as of 2023).
}
\examples{
uni_freiburg_grey
unikn::seecol(uni_freiburg_grey, main = "Grey colors of the University of Freiburg (2022)")
unikn::demopal(uni_freiburg_grey, type = 1, main = "Grey colors of Freiburg University (2022)")

}
\seealso{
\code{\link{uni_freiburg_br}} for the default colors of the University of Freiburg;  
\code{\link{uni_freiburg_info}} for the info colors of the University of Freiburg;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0}},
\code{\link{fu_1}},
\code{\link{fu_2}},
\code{\link{fu_3}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2022-10-20.
}
\concept{German university color palettes}
\keyword{datasets}
