% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stanford.R
\docType{data}
\name{stanford_1}
\alias{stanford_1}
\title{Primary colors of Stanford University, USA}
\format{
An object of class \code{character} of length 15.
}
\source{
Color definitions are based on \href{https://www.stanford.edu}{Stanford}'s 
\href{https://identity.stanford.edu/design-elements/color/}{Color manual}.
}
\usage{
stanford_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{stanford_1} provides the 15 primary colors
of \href{https://www.stanford.edu/}{Stanford University}, CA, USA.
}
\details{
\href{https://www.stanford.edu/}{UStanford}'s 
primary color palette consists of 
\code{Cardinal red}, \code{white}, \code{black}, and \code{cool grey}.

The layouts lean heavily on these colors, which are 
\code{"Cardinal red"} (defined as HEX #8C1515),
\code{"Cardinal red light"} (defined as HEX #B83A4B),
\code{"Cardinal red dark"} (defined as HEX #820000),
\code{"white"} (defined as HEX #FFFFFF),
\code{"black"} (defined as HEX #2E2D29),
\code{"black 90"} (defined as HEX #43423E),
\code{"black 80"} (defined as HEX #585754),
\code{"black 70"} (defined as HEX #6D6C69),
\code{"black 60"} (defined as HEX #767674),
\code{"black 50"} (defined as HEX #979694),
\code{"black 40"} (defined as HEX #ABABA9),
\code{"black 30"} (defined as HEX #C0C0BF),
\code{"black 20"} (defined as HEX #D5D5D4),
\code{"black 10"} (defined as HEX #EAEAEA), and 
\code{"cool grey"} (defined as HEX #53565A).
}
\examples{
stanford_1
unikn::seecol(stanford_1, col_bg = "grey96",  
              main = "The primary colors of Stanford University")  # view color palette

}
\seealso{
\code{\link{stanford_2}} for secondary, accent colors of Stanford University;
\code{\link{stanford_3}} for web colors of Stanford University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_2}},
\code{\link{stanford_3}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
