% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Chicago.R
\docType{data}
\name{chicago_2}
\alias{chicago_2}
\title{Accent colors of the University of Chicago, USA}
\format{
An object of class \code{character} of length 23.
}
\source{
Color definitions are based on the University of Chicago's 
\href{https://creative.uchicago.edu/resources/}{Brand Identity Guidelines}.
}
\usage{
chicago_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{chicago_2} provides the 21 accent colors
of the \href{https://www.uchicago.edu/}{University of Chicago}, USA.
}
\details{
The secondary palette is to be used sparingly and always in conjunction with the primary palette. In other words, all print
and digital communications will utilize the primary palette as the dominant color scheme, with the secondary color palette
providing subtle accent color options with

\code{"goldenrod"} (defined as Pantone 124C, CMYK 0/25/100/4, RGB 234/170/0, HEX #EAAA00),
\code{"light_goldenrod"} (defined as Pantone 129C, CMYK 0/12/90/0, RGB 243/208/62, HEX #F3D03E),
\code{"dark_goldenrod"} (defined as Pantone 131C, CMYK 3/36/100/11, RGB 204/138/0, HEX #CC8A00),
\code{"terracotta"} (defined as Pantone 138C, CMYK 0/46/100/6, RGB 222/124/0, HEX #DE7C00),
\code{"light_terracotta"} (defined as Pantone 157C, CMYK 0/37/74/0, RGB 236/161/84, HEX #ECA154),
\code{"dark_terracotta"} (defined as Pantone 1675C, CMYK 5/71/100/27, RGB 169/67/30, HEX #A9431E),
\code{"ivy"} (defined as Pantone 576C, CMYK 44/4/88/22, RGB 120/157/74, HEX #789D4A),
\code{"light_ivy"} (defined as Pantone 577C, CMYK 29/2/58/2, RGB 169/196/127, HEX #A9C47F),
\code{"dark_ivy"} (defined as Pantone 574C, CMYK 52/20/98/66, RGB 19/48/28, HEX #13301C),
\code{"forest"} (defined as Pantone 7483C, CMYK 82/15/85/50, RGB 39/93/56, HEX #275D38),
\code{"light_forest"} (defined as Pantone 7494C, CMYK 31/6/42/16, RGB 156/175/136, HEX #9CAF88),
\code{"dark_forest"} (defined as Pantone 553C, CMYK 72/28/65/74, RGB 40/71/52, HEX #284734),
\code{"lake"} (defined as Pantone 633C, CMYK 100/7/10/31, RGB 0/115/150, HEX #007396),
\code{"light_lake"} (defined as Pantone 631C, CMYK 70/0/15/2, RGB 62/177/200, HEX #3EB1C8),
\code{"dark_lake"} (defined as Pantone 303C, CMYK 100/55/18/76, RGB 0/42/58, HEX #002A3A),
\code{"violet"} (defined as Pantone 519C, CMYK 63/90/9/50, RGB 89/49/95, HEX #59315F),
\code{"light_violet"} (defined as Pantone 5205C, CMYK 25/42/13/43, RGB 134/100/122, HEX #86647A),
\code{"dark_violet"} (defined as Pantone 7449C, CMYK 63/96/21/83, RGB 65/39/59, HEX #41273B),
\code{"brick*"} (defined as Pantone 1807C, CMYK 6/85/71/30, RGB 164/52/58, HEX #A4343A),
\code{"light_brick"} (defined as Pantone 7522C, CMYK 10/58/54/18, RGB 180/106/85, HEX #B46A55), and
\code{"dark_brick"} (defined as Pantone 1817C, CMYK 20/70/59/60, RGB 100/51/53, HEX #643335).
}
\examples{
chicago_2
unikn::seecol(chicago_2, main = "Accent colors Chicago Uni") # view color palette

}
\seealso{
\code{\link{chicago_1}} for primary colors of University of Chicago;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCSD_1_core}},
\code{\link{UCSD_2_accent}},
\code{\link{UCSD_3_neutral}},
\code{\link{asu_1}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{birmingham_1}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu_1}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{carleton_1}},
\code{\link{chicago_1}},
\code{\link{columbia}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{dundee_background}},
\code{\link{dundee_block}},
\code{\link{dundee_core}},
\code{\link{dundee_highlight}},
\code{\link{edinburgh_1}},
\code{\link{eth_1}},
\code{\link{eth_2}},
\code{\link{eth_3}},
\code{\link{fu_pal_0}},
\code{\link{fu_pal_1}},
\code{\link{fu_pal_2}},
\code{\link{fu_pal_3}},
\code{\link{galway_1}},
\code{\link{galway_2}},
\code{\link{guelph}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{hu_pal_1}},
\code{\link{hu_pal_2}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{lancaster_1}},
\code{\link{lancaster_2}},
\code{\link{laval}},
\code{\link{limerick_1}},
\code{\link{lmu_pal_1}},
\code{\link{lmu_pal_2}},
\code{\link{lmu_pal_3}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_2}},
\code{\link{mit_pal}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{mpg_pal}},
\code{\link{msu_pal}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ottawa_1}},
\code{\link{oxford_blog}},
\code{\link{oxford_brand}},
\code{\link{oxford_error}},
\code{\link{oxford_general}},
\code{\link{oxford_graduate}},
\code{\link{oxford_link}},
\code{\link{oxford_shades}},
\code{\link{oxford_socialmedia}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{queens_1}},
\code{\link{queens_2}},
\code{\link{rpi_pal_1}},
\code{\link{rpi_pal_2}},
\code{\link{rpi_pal_3}},
\code{\link{rptu_pal}},
\code{\link{sfu_brand}},
\code{\link{standrews_1}},
\code{\link{standrews_2}},
\code{\link{stanford_1}},
\code{\link{stanford_2_accent}},
\code{\link{stanford_3_web}},
\code{\link{toronto_1}},
\code{\link{trinity_1}},
\code{\link{ubc_1}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_primary}},
\code{\link{ucalgary_secondary}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uci_1}},
\code{\link{uflorida_1}},
\code{\link{umass_2}},
\code{\link{umass_brand}},
\code{\link{umass_neutrals}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg_1}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_manchester_1}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_2_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_3}},
\code{\link{waikato}},
\code{\link{western_uni_1}},
\code{\link{yale_1}},
\code{\link{yeshiva}},
\code{\link{york1}},
\code{\link{york2}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{university color palettes}
\keyword{datasets}
