% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unglue.R
\name{unglue_detect}
\alias{unglue_detect}
\title{Detect if strings are matched by a set of unglue patterns}
\usage{
unglue_detect(x, patterns, open = "{", close = "}", convert = FALSE,
  multiple = NULL)
}
\arguments{
\item{x}{a character vector to unglue.}

\item{patterns}{a character vector or a list of character vectors, if a list,
items will be pasted using an empty separator (\code{""}).}

\item{open}{The opening delimiter.}

\item{close}{The closing delimiter.}

\item{convert}{If \code{TRUE}, will convert columns of output using
\code{utils::type.convert()} with parameter \code{as.is = TRUE}, alternatively, can
be a converting function, such as \code{readr::type_convert}. Formula notation
is supported if the package \code{rlang} is installed, so things like
\code{convert = ~type_convert(., numerals = "warn.loss")} are possible.}

\item{multiple}{The aggregation function to use if several subpatterns are
named the same, by default no function is used and subpatterns named the
same will match the same value. If a function is provided it will be fed
the conflicting values as separate arguments. Formula notation
is supported if the package \code{rlang} is installed.}
}
\value{
a vector of logical.
}
\description{
Returns a logical indicating wether input strings were matched by one or more patterns
}
\examples{
sentences <- c("666 is [a number]", "foo is [a word]",
               "42 is [the answer]", "Area 51 is [unmatched]")
patterns <- c("{number=\\\\d+} is [{what}]", "{word=\\\\D+} is [{what}]")
unglue_detect(sentences, patterns)
}
