% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_init_csv.r
\name{create_init_csv}
\alias{create_init_csv}
\title{Creates the \code{init.csv}}
\usage{
create_init_csv(
  silo_names = character(),
  start_times = character(),
  end_times = character(),
  treatment_times = character(),
  covariates = character(),
  filename = "init.csv",
  filepath = tempdir()
)
}
\arguments{
\item{silo_names}{A character vector of silo names.}

\item{start_times}{A character vector of start times.}

\item{end_times}{A character vector of end times.}

\item{treatment_times}{A character vector of treatment times.}

\item{covariates}{A character vector of covariates, or, \code{FALSE} (default).}

\item{filename}{A character filename for the created initializing CSV file.
Defaults to \code{"init.csv"}.}

\item{filepath}{Filepath to save the CSV file. Defaults to \code{tempdir()}.}
}
\value{
A data frame containing the contents written to the CSV file.
The CSV file is saved in the specified directory (or in a temporary
directory by default) with the default filename \code{init.csv}.
}
\description{
The \code{create_init_csv()} function generates a CSV file with information
on each silo's start times, end times, and treatment times.
If parameters are left empty, generates a blank CSV with only the headers.
}
\details{
Ensure dates are entered consistently in the same date format.
Call \code{\link[=undid_date_formats]{undid_date_formats()}} to view valid date formats. Control silos
should be marked as \code{"control"} in the \code{treatment_times} vector. If
\code{covariates} is \code{FALSE}, no covariate column will be included in the CSV.
}
\examples{
create_init_csv(
  silo_names = c("73", "46", "54", "23", "86", "32",
                 "71", "58", "64", "59", "85", "57"),
  start_times = "1989",
  end_times = "2000",
  treatment_times = c(rep("control", 6),
                      "1991", "1993", "1996", "1997", "1997", "1998"),
  covariates = c("asian", "black", "male")
)
unlink(file.path(tempdir(), "init.csv"))
}
