% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxPlot}
\alias{umxPlot}
\title{Quickly plot y ~ x with a regression line and R^2, and nice labels.}
\usage{
umxPlot(
  x,
  y = NULL,
  data,
  xlab = x,
  ylab = y,
  title = paste0(y, " as a function of ", x),
  fitx = NA,
  fity = NA,
  geom_point = TRUE,
  method = c("lm", "auto", "loess", "glm", "gam"),
  family = c("gaussian", "binomial", "Gamma", "inverse", "poisson", "quasi",
    "quasibinomial", "quasipoisson")
)
}
\arguments{
\item{x}{formula or (alternatively) x as string}

\item{y}{variable as string.}

\item{data}{The data for the graph.}

\item{xlab}{X-axis label (default y).}

\item{ylab}{Y-axis label (default y).}

\item{title}{Graph title. Default =  paste0(y, " as a function of ", x)}

\item{fitx}{x location for the fit summary (default 1).}

\item{fity}{y location for the fit summary (default 2).}

\item{geom_point}{show points? (TRUE)}

\item{method}{Method for fitting curve (default = lm)}

\item{family}{for glm default = "gaussian"}
}
\value{
\itemize{
\item plot you can edit.
}
}
\description{
Want a figure for your paper or presentation but not the work of combining \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}},
\code{\link[ggplot2:geom_smooth]{ggplot2::geom_smooth()}} and \code{method} options, plus \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}. Organizing \code{\link[ggplot2:labs]{ggplot2::labs()}} and its
\code{x}, \code{y}, and \code{title} components. Adding your preferred theme like \code{\link[ggplot2:ggtheme]{ggplot2::theme_gray()}}, plus recalling
for \code{\link[cowplot:draw_label]{cowplot::draw_label()}}, and/or \code{\link[ggplot2:annotate]{ggplot2::annotate()}} to draw math-enabled labels on the plot, as well
as the required \code{\link[=bquote]{bquote()}}, and extracting the relevant fit statistics from \code{\link[=lm]{lm()}} and the subsidiary tasks
of \code{\link[=reformulate]{reformulate()}} programmatic variables?

\code{umxPlot} just takes \code{y ~ x} (or "x" and "y" as strings), and gives you a nicely labelled plot, with a fitted line, the
\ifelse{html}{\out{<em>R</em><sup>2</sup>}}{\eqn{R^2}} so readers can see how well this fitted. It knows how to put Greek symbols like \eqn{beta} into axes.
}
\examples{
data(mtcars)
umxPlot(mpg ~ wt, data = mtcars, fitx = 2, fity = 10)
umxPlot(x = "wt", y = "mpg", mtcars, fitx = 2, fity = 10)
}
\seealso{
\itemize{
\item \code{\link[ggplot2:qplot]{ggplot2::qplot()}}
}

Other Plotting functions: 
\code{\link{ggAddR}()},
\code{\link{plot.MxLISRELModel}()},
\code{\link{plot.MxModelTwinMaker}()},
\code{\link{plot.MxModel}()},
\code{\link{umxPlotACEcov}()},
\code{\link{umxPlotACEv}()},
\code{\link{umxPlotACE}()},
\code{\link{umxPlotCP}()},
\code{\link{umxPlotDoC}()},
\code{\link{umxPlotFun}()},
\code{\link{umxPlotGxEbiv}()},
\code{\link{umxPlotGxE}()},
\code{\link{umxPlotIP}()},
\code{\link{umxPlotSexLim}()},
\code{\link{umxPlotSimplex}()},
\code{\link{umx}}
}
\concept{Plotting functions}
