% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_set_table_format}
\alias{umx_set_table_format}
\title{umx_set_table_format}
\usage{
umx_set_table_format(knitr.table.format = NULL, silent = FALSE)
}
\arguments{
\item{knitr.table.format}{format for tables (if empty, returns the current value of knitr.table.format)}

\item{silent}{If TRUE, no message will be printed.}
}
\value{
\itemize{
\item Current knitr.table.format setting
}
}
\description{
Set knitr.table.format default (output style for tables). Legal values are
"latex", "html", "markdown", "pandoc", and "rst".
}
\examples{
library(umx)
umx_set_table_format() # show current state
old = umx_set_table_format() # store existing value
umx_set_table_format("latex")
umx_set_table_format("html")
umx_set_table_format("markdown")
umx_set_table_format("") # get available options
umx_set_table_format(old)    # reinstate
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Get and set: 
\code{\link{umx_get_checkpoint}()},
\code{\link{umx_get_options}()},
\code{\link{umx_set_auto_plot}()},
\code{\link{umx_set_auto_run}()},
\code{\link{umx_set_checkpoint}()},
\code{\link{umx_set_condensed_slots}()},
\code{\link{umx_set_cores}()},
\code{\link{umx_set_data_variance_check}()},
\code{\link{umx_set_dollar_symbol}()},
\code{\link{umx_set_optimization_options}()},
\code{\link{umx_set_optimizer}()},
\code{\link{umx_set_plot_file_suffix}()},
\code{\link{umx_set_plot_format}()},
\code{\link{umx_set_plot_use_hrbrthemes}()},
\code{\link{umx_set_separator}()},
\code{\link{umx_set_silent}()},
\code{\link{umx}}
}
\concept{Get and set}
