% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{umxRun}
\alias{umxRun}
\title{umxRun: Run an mxModel}
\usage{
umxRun(
  model,
  tryHard = c("yes", "no", "ordinal", "search"),
  calc_sat = TRUE,
  setValues = FALSE,
  setLabels = FALSE,
  intervals = FALSE,
  optimizer = NULL,
  comparison = NULL
)
}
\arguments{
\item{model}{The \code{\link[=mxModel]{mxModel()}} you wish to run.}

\item{tryHard}{How to tryHard. Default = "yes". Alternatives "no", "ordinal", "search"}

\item{calc_sat}{Whether to calculate the saturated and independence models (for raw \code{\link[=mxData]{mxData()}} \code{\link[=mxModel]{mxModel()}}s)}

\item{setValues}{Whether to set the starting values of free parameters (default = FALSE)}

\item{setLabels}{Whether to set the labels (default =  FALSE)}

\item{intervals}{Whether to run mxCI confidence intervals (default = FALSE) intervals = FALSE}

\item{optimizer}{optional to set the optimizer.}

\item{comparison}{Comparison model (will be used to drive umxCompare() after umxRun}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}}
}
}
\description{
\code{umxRun} is a version of \code{\link[=mxRun]{mxRun()}} which can run also set start values, labels, and run multiple times
It can also calculate the saturated and independence likelihoods necessary for most fit indices.
\strong{Note} this is not needed for umxRAM models or twin models - it is just a convenience to get base OpenMx models to run.
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 = mxModel("fact", type="RAM", manifestVars=manifests, latentVars=latents,
	mxPath(latents  , to = manifests),
	mxPath(manifests, arrows = 2),
	mxPath(latents  , arrows = 2, free = FALSE, values = 1),
	mxData(cov(demoOneFactor), type = "cov", numObs=500)
)

m1 = umxRun(m1) # just run: will create saturated model if needed
\dontrun{
m1 = umxRun(m1, setValues = TRUE, setLabels = TRUE) # set start values and label all parameters
umxSummary(m1, std = TRUE)
m1 = mxModel(m1, mxCI("G_to_x1")) # add one CI
m1 = mxRun(m1, intervals = TRUE)
residuals(m1, run = TRUE) # get CIs on all free parameters
confint(m1) # OpenMx's SE-based CIs
umxConfint(m1, run = TRUE) # get likelihood-based CIs on all free parameters
m1 = umxRun(m1, n = 10) # re-run up to 10 times if not green on first run
}

}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Advanced Model Building Functions: 
\code{\link{umxAlgebra}()},
\code{\link{umxFixAll}()},
\code{\link{umxJiggle}()},
\code{\link{umxThresholdMatrix}()},
\code{\link{umxUnexplainedCausalNexus}()},
\code{\link{umx}},
\code{\link{xmuLabel}()},
\code{\link{xmuValues}()}
}
\concept{Advanced Model Building Functions}
