% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{umxACEcov}
\alias{umxACEcov}
\title{Run a Cholesky with covariates that are random (in the expected covariance matrix)}
\usage{
umxACEcov(
  name = "ACEcov",
  selDVs,
  selCovs,
  dzData,
  mzData,
  sep = NULL,
  type = c("Auto", "FIML", "cov", "cor", "WLS", "DWLS", "ULS"),
  allContinuousMethod = c("cumulants", "marginals"),
  dzAr = 0.5,
  dzCr = 1,
  addStd = TRUE,
  addCI = TRUE,
  boundDiag = 0,
  equateMeans = TRUE,
  bVector = FALSE,
  autoRun = getOption("umx_auto_run"),
  tryHard = c("no", "yes", "ordinal", "search"),
  optimizer = NULL
)
}
\arguments{
\item{name}{The name of the model (defaults to"ACE").}

\item{selDVs}{The variables to include from the data (do not include sep).}

\item{selCovs}{The covariates to include from the data (do not include sep).}

\item{dzData}{The DZ dataframe.}

\item{mzData}{The MZ dataframe.}

\item{sep}{Separator text between basename for twin variable names. Often "_T".
Used to expand selDVs into full column names, i.e., "dep" --> c("dep_T1", "dep_T2").}

\item{type}{Analysis method one of c("Auto", "FIML", "cov", "cor", "WLS", "DWLS", "ULS")}

\item{allContinuousMethod}{"cumulants" or "marginals". Used in all-continuous WLS data to determine if a means model needed.}

\item{dzAr}{The DZ genetic correlation (defaults to .5, vary to examine assortative mating).}

\item{dzCr}{The DZ "C" correlation (defaults to 1: set to .25 to make an ADE model).}

\item{addStd}{Whether to add the algebras to compute a std model (defaults to TRUE).}

\item{addCI}{Whether to add intervals to compute CIs (defaults to TRUE).}

\item{boundDiag}{= Whether to bound the diagonal of the a, c, and e matrices.}

\item{equateMeans}{Whether to equate the means across twins (defaults to TRUE).}

\item{bVector}{Whether to compute row-wise likelihoods (defaults to FALSE).}

\item{autoRun}{Whether to run the model (default), or just to create it and return without running.}

\item{tryHard}{Default ('no') uses normal mxRun. "yes" uses mxTryHard. Other options: "ordinal", "search"}

\item{optimizer}{optionally set the optimizer. Default (NULL) does nothing.}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}} of subclass mxModel.ACEcov
}
}
\description{
Often, researchers include covariates in 2-group Cholesky \code{\link[=umxACE]{umxACE()}} twin models.
The umxACEcov 'random' option models the covariates in the expected covariance matrix, thus allowing
all data to be preserved. The downside is that this method has a strong assumption
of multivariate normality. Covariates like age, which are perfectly correlated in twins cannot be used.
Covariates like sex, which are ordinal, violate the normality assumption.
Binary and ordinal covariates like sex also violate the normality assumption. Which is most of the use cases :-(.
}
\details{
The following figure shows how the ACE model with random covariates appears as a path diagram:

\if{html}{\figure{ACEcovVarianceModel.png}{options: width=50\% alt="Figure: ACEcovVarianceModel.png"}}
\if{latex}{\figure{ACEcovVarianceModel.pdf}{options: width=7cm}}
}
\examples{
\dontrun{
# ============================================
# = BMI, can't use Age as a random covariate =
# ============================================
require(umx)
data(twinData)
# Replicate age to age1 & age2
twinData$age1 = twinData$age2 = twinData$age
mzData = subset(twinData, zygosity == "MZFF")
dzData = subset(twinData, zygosity == "DZFF")

# =====================================================================
# = Trying to use identical var (like age) as a random cov is ILLEGAL =
# =====================================================================
m1 = umxACEcov(selDVs = "bmi", selCovs = "age", dzData = dzData, mzData = mzData, sep = "")

# ========================================================
# = Use an lm-based age-residualisation approach instead =
# ========================================================

resid_data = umx_residualize("bmi", "age", suffixes = 1:2, twinData)
mzData = subset(resid_data, zygosity == "MZFF")
dzData = subset(resid_data, zygosity == "DZFF")
m2     = umxACE("resid", selDVs = "bmi", dzData = dzData, mzData = mzData, sep = "")

# Univariate BMI without covariate of age for comparison
mzData = subset(twinData, zygosity == "MZFF")
dzData = subset(twinData, zygosity == "DZFF")
m3 = umxACE("raw_bmi", selDVs = "bmi", dzData = dzData, mzData = mzData, sep = "")

# ===========================================================================
# = A bivariate example (need a dataset with a VIABLE COVARIATE to do this) =
# ===========================================================================
selDVs  = c("ht", "wt") # Set the DV
selCovs = c("income") # Set the COV
selVars = umx_paste_names(selDVs, covNames = selCovs, sep = "", sep = 1:2)
# 80 rows so example runs fast on CRAN
mzData = subset(twinData, zygosity == "MZFF", selVars)[1:80, ]
dzData = subset(twinData, zygosity == "DZFF", selVars)[1:80, ]
m1 = umxACEcov(selDVs = selDVs, selCovs = selCovs,
   dzData = dzData, mzData = mzData, sep = "", autoRun = TRUE
)
}
}
\references{
Neale, M. C., & Martin, N. G. (1989). The effects of age, sex,
and genotype on self-report drunkenness following a challenge dose of alcohol.
\emph{Behavior Genetics}, \strong{19}, 63-78. doi{10.1007/BF01065884}.

Schwabe, I., Boomsma, D. I., Zeeuw, E. L., & Berg, S. M. (2015). A New Approach
to Handle Missing Covariate Data in Twin Research : With an Application to
Educational Achievement Data. \emph{Behavior Genetics}, \strong{46}, 583-95. doi{10.1007/s10519-015-9771-1}.
}
\seealso{
Other Twin Modeling Functions: 
\code{\link{power.ACE.test}()},
\code{\link{umxACEv}()},
\code{\link{umxACE}()},
\code{\link{umxCP}()},
\code{\link{umxDoCp}()},
\code{\link{umxDoC}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxEbiv}()},
\code{\link{umxGxE}()},
\code{\link{umxIP}()},
\code{\link{umxReduceACE}()},
\code{\link{umxReduceGxE}()},
\code{\link{umxReduce}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSimplex}()},
\code{\link{umxSummarizeTwinData}()},
\code{\link{umxSummaryACEv}()},
\code{\link{umxSummaryACE}()},
\code{\link{umxSummaryDoC}()},
\code{\link{umxSummaryGxEbiv}()},
\code{\link{umxSummarySexLim}()},
\code{\link{umxSummarySimplex}()},
\code{\link{umxTwinMaker}()},
\code{\link{umx}}
}
\concept{Twin Modeling Functions}
