% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_umxGxEbiv.R
\name{umxSummaryGxEbiv}
\alias{umxSummaryGxEbiv}
\alias{umxSummary.MxModelGxEbiv}
\title{Summarize a bivariate GxE twin model}
\usage{
umxSummaryGxEbiv(
  model = NULL,
  digits = 2,
  xlab = NA,
  location = "topleft",
  separateGraphs = FALSE,
  file = getOption("umx_auto_plot"),
  comparison = FALSE,
  std = NULL,
  reduce = FALSE,
  CIs = NULL,
  report = c("markdown", "html"),
  returnStd = NULL,
  show = c("std", "raw"),
  ...
)
}
\arguments{
\item{model}{A fitted \code{\link[=umxGxEbiv]{umxGxEbiv()}} model to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{xlab}{label for the x-axis of plot}

\item{location}{default = "topleft"}

\item{separateGraphs}{Std and raw plots in separate graphs? (default = FALSE)}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{comparison}{mxCompare model with comparison (default = FALSE).}

\item{std}{Whether to show the standardized model (not implemented! TRUE)}

\item{reduce}{Whether to run and tabulate a complete model reduction...(Defaults to FALSE)}

\item{CIs}{Confidence intervals (FALSE)}

\item{report}{markdown or html (html opens in browser)}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{show}{Here to support being called from generic xmu_safe_run_summary. User should ignore: can be c("std", "raw")}

\item{...}{Optional additional parameters}
}
\value{
\itemize{
\item optional \code{\link[=mxModel]{mxModel()}}
}
}
\description{
\code{umxSummaryGxEbiv} summarizes a bivariate moderation model, as returned by \code{\link[=umxGxEbiv]{umxGxEbiv()}}.
}
\examples{
data(twinData)
df = umx_scale_wide_twin_data(twinData, varsToScale = c("ht", "wt"), sep = "")
mzData  = subset(df, zygosity \%in\%  c("MZFF", "MZMM"))
dzData  = subset(df, zygosity \%in\%  c("DZFF", "DZMM", "DZOS"))

\dontrun{
m1 = umxGxEbiv(selDVs = "wt", selDefs = "ht", 
	dzData = dzData, mzData = mzData, sep = "", dropMissingDef = TRUE)
# Plot Moderation
umxSummary(m1)
umxSummary(m1, location = "topright")
umxSummary(m1, separateGraphs = FALSE)
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link{umxGxEbiv}()}, \code{\link[=plot]{plot()}}, \code{\link[=umxSummary]{umxSummary()}} work for IP, CP, GxE, and ACE models.
}

Other Twin Reporting Functions: \code{\link{umxPlotCP}()},
  \code{\link{umxReduceACE}()},
  \code{\link{umxReduceGxE}()}, \code{\link{umxReduce}()},
  \code{\link{umxSummarizeTwinData}()},
  \code{\link{umxSummaryACEcov}()},
  \code{\link{umxSummaryACEv}()},
  \code{\link{umxSummaryACE}()},
  \code{\link{umxSummaryCP}()},
  \code{\link{umxSummaryGxE}()},
  \code{\link{umxSummaryIP}()},
  \code{\link{umxSummarySexLim}()},
  \code{\link{umxSummarySimplex}()}, \code{\link{umx}}
}
\concept{Twin Reporting Functions}
