% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxCI}
\alias{umxCI}
\title{Add (and, optionally, run) confidence intervals to a structural model.}
\usage{
umxCI(model = NULL, which = c("ALL", NA, "list of your making"),
  remove = FALSE, run = c("no", "yes", "if necessary", "show"),
  interval = 0.95, type = c("both", "lower", "upper"),
  showErrorCodes = TRUE)
}
\arguments{
\item{model}{The \code{\link[=mxModel]{mxModel()}} you wish to report \code{\link[=mxCI]{mxCI()}}s on}

\item{which}{What CIs to add: c("ALL", NA, "list of your making")}

\item{remove}{= FALSE (if set, removes existing specified CIs from the model)}

\item{run}{Whether or not to compute the CIs. Valid values = "no" (default), "yes", "if necessary".
'show' means print the intervals if computed, or list their names if not.}

\item{interval}{The interval for newly added CIs (defaults to 0.95)}

\item{type}{The type of CI (defaults to "both", options are "lower" and  "upper")}

\item{showErrorCodes}{Whether to show errors (default == TRUE)}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}}
}
}
\description{
\code{umxCI} adds \code{\link[OpenMx:mxCI]{OpenMx::mxCI()}} calls for requested (default all) parameters in a model,
runs these CIs if necessary, and reports them in a neat summary.
}
\details{
\code{umxCI} also reports if any problems were encountered. The codes are standard OpenMx errors and warnings
\itemize{
\item 1: The final iterate satisfies the optimality conditions to the accuracy requested, but the sequence of iterates has not yet converged. NPSOL was terminated because no further improvement could be made in the merit function (Mx status GREEN)
\item 2: The linear constraints and bounds could not be satisfied. The problem has no feasible solution.
\item 3: The nonlinear constraints and bounds could not be satisfied. The problem may have no feasible solution.
\item 4: The major iteration limit was reached (Mx status BLUE).
\item 6: The model does not satisfy the first-order optimality conditions to the required accuracy, and no improved point for the merit function could be found during the final linesearch (Mx status RED)
\item 7: The function derivatives returned by funcon or funobj appear to be incorrect.
\item 9: An input parameter was invalid.
}
If \code{run = "no"}, the function simply adds the CI requests, but returns the model without running them.
}
\examples{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)

m1 = umxRAM("One Factor", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)
m1$intervals # none yet - empty list()
m1 = umxCI(m1)
m1$intervals # $G_to_x1
m1 = umxCI(m1, remove = TRUE) # remove CIs from the model and return it

# ========================
# = A twin model example =
# ========================
data(twinData) 
mzData <- subset(twinData, zygosity == "MZFF")
dzData <- subset(twinData, zygosity == "DZFF")
m1 = umxACE(selDVs = c("bmi1","bmi2"), dzData = dzData, mzData = mzData)
\dontrun{
umxCI(m1, run = "show") # show what will be requested
umxCI(m1, run = "yes") # actually compute the CIs
# Don't force update of CIs, but if they were just added, then calculate them
umxCI(m1, run = "if necessary")
m1 = umxCI(m1, remove = TRUE) # remove them all
m1$intervals # none!
# Show what parameters are available to get CIs on
umxParameters(m1) 
# Request a CI by label:
m1 = umxCI(m1, "a_r1c1", run = "yes")
}
}
\references{
\itemize{
\item \url{https://www.github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link[stats:confint]{stats::confint()}}, \code{\link[=umxConfint]{umxConfint()}}, \code{\link[=umxCI]{umxCI()}}, \code{\link[=umxModify]{umxModify()}}
}

Other Reporting functions: \code{\link{RMSEA.MxModel}()},
  \code{\link{RMSEA.summary.mxmodel}()},
  \code{\link{RMSEA}()},
  \code{\link{extractAIC.MxModel}()},
  \code{\link{loadings}()},
  \code{\link{residuals.MxModel}()},
  \code{\link{umxCI_boot}()}, \code{\link{umxCompare}()},
  \code{\link{umxConfint}()}, \code{\link{umxExpCov}()},
  \code{\link{umxExpMeans}()},
  \code{\link{umxFitIndices}()},
  \code{\link{umxPlotACEv}()}, \code{\link{umxRotate}()},
  \code{\link{umxSummary.MxModel}()}
}
\concept{Reporting functions}
