% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_long2wide}
\alias{umx_long2wide}
\title{Take a long twin-data file and make it wide (one family per row)}
\usage{
umx_long2wide(data, famID = NA, twinID = NA, zygosity = NA,
  vars2keep = NA, passalong = NA)
}
\arguments{
\item{data}{The original (long-format) data file}

\item{famID}{The unique identifier for members of a family}

\item{twinID}{The twinID. Typically 1, 2, 50 51, etc...}

\item{zygosity}{Typically MZFF, DZFF MZMM, DZMM DZOS}

\item{vars2keep}{= The variables you wish to analyse (these will be renamed with paste0("_T", twinID)}

\item{passalong}{= Variables you wish to pass-through (keep, even though not twin vars)}
}
\value{
\itemize{
\item dataframe in wide format
}
}
\description{
\code{umx_long2wide} merges on \code{famID}. Family members are ordered by \code{twinID}.

twinID is equivalent to birthorder. Up to 10 twinIDs are allowed (family order).

\emph{Note}: Not all data sets have an order column, but it is essential to rank subjects correctly.

\emph{Note}: The functions assumes that if zygosity or any passalong variables are NA in the first
family member, they are NA everywhere. i.e., it does not hunt for values that
are present elsewhere to try and self-heal missing data.
}
\examples{
# ================================================================
# = First we have to make a long format file to base the demo on =
# ================================================================
tmp = twinData[, -2]
tmp$twinID1 = 1
tmp$twinID2 = 2
long = umx_wide2long(data = tmp, sep = "")
#

# OK. Now to demo long2wide...

# Keeping all columns
wide = umx_long2wide(data= long, famID= "fam", twinID= "twinID", zygosity= "zygosity")
names(wide) # some vars, like part, should have been passed along instead of made into "part_T1"

# Just keep bmi and wt
wide = umx_long2wide(data= long, famID= "fam", twinID= "twinID", 
    zygosity= "zygosity", vars2keep = c("bmi", "wt"))
names(wide)

# "fam" "twinID" "zygosity" "bmi_T1" "wt_T1" "bmi_T2" "wt_T2"

# Keep bmi and wt, and pass through 'cohort'
wide = umx_long2wide(data= long, famID= "fam", twinID= "twinID", zygosity= "zygosity", 
  vars2keep = c("bmi", "wt"), passalong = "cohort")
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link{merge}}
}

Other Twin Data functions: \code{\link{umx_make_TwinData}},
  \code{\link{umx_residualize}},
  \code{\link{umx_scale_wide_twin_data}},
  \code{\link{umx_wide2long}}, \code{\link{umx}}
}
\concept{Twin Data functions}
