% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxReduceGxE}
\alias{umxReduceGxE}
\title{Reduce a GxE model.}
\usage{
umxReduceGxE(model, report = c("markdown", "inline", "html", "report"),
  baseFileName = "tmp", ...)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to reduce}

\item{report}{How to report the results. "html" = open in browser}

\item{baseFileName}{(optional) custom filename for html output (defaults to "tmp")}

\item{...}{Other parameters to control model summary}
}
\value{
-
}
\description{
This function can perform model reduction for \code{\link{umxGxE}}, 
testing dropping means-moderation, a`,c` & e`, as well as c & c`, a & a` etc.
}
\details{
It reports the results in a table. Set the format of the table with
\code{\link{umx_set_table_format}}()., or set `report` to "html" to open a
table for pasting into a word processor.
}
\examples{
\dontrun{
model = umxReduce(model)
}
}
\references{
- \url{http://tbates.github.io}
}
\seealso{
Other Twin Reporting Functions: \code{\link{umxReduceACE}},
  \code{\link{umx}}
}
