% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxRAM2Ordinal}
\alias{umxRAM2Ordinal}
\title{umxRAM2Ordinal}
\usage{
umxRAM2Ordinal(model, verbose = T, thresholds = c("deviationBased",
  "direct", "ignore", "left_censored"), name = NULL, showEstimates = TRUE,
  refModels = NULL, autoRun = getOption("umx_auto_run"))
}
\arguments{
\item{model}{An RAM model to add thresholds too.}

\item{verbose}{Tell the user what was added and why (Default = TRUE)}

\item{thresholds}{How to implement thresholds: c("deviationBased", "direct", "ignore", "left_censored")}

\item{name}{= A new name for the modified model (NULL means leave it as it)}

\item{showEstimates}{= Whether to show estimates in the summary (if autorunning) TRUE}

\item{refModels}{pass in reference models if available. Use FALSE to supress computing these if not provided.}

\item{autoRun}{= whether to run the model before returning it: defaults to getOption("umx_auto_run"))}
}
\value{
- \code{\link{mxModel}}
}
\description{
umxRAM2Ordinal  converts a RAM model whose data contain ordinal vars to a threshold-based model
}
\examples{
\dontrun{
m1 = umxRAM2Ordinal(model)
}
}
\seealso{
- \code{\link{umxRAM}}

Other Model Building Functions: \code{\link{umxDiagnose}},
  \code{\link{umxLabel}}, \code{\link{umxLatent}},
  \code{\link{umxMatrix}}, \code{\link{umxModify}},
  \code{\link{umxPath}}, \code{\link{umxRAM}},
  \code{\link{umxRun}}, \code{\link{umxThresholdMatrix}},
  \code{\link{umxValues}},
  \code{\link{umx_fix_first_loadings}},
  \code{\link{umx_fix_latents}}, \code{\link{umx}}
}

