% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{extractAIC.MxModel}
\alias{extractAIC.MxModel}
\title{extractAIC from MxModel}
\usage{
\method{extractAIC}{MxModel}(fit, scale, k, ...)
}
\arguments{
\item{fit}{an fitted \code{\link{mxModel}} from which to get the AIC}

\item{scale}{not used}

\item{k}{not used}

\item{...}{any other parameters (not used)}
}
\value{
- AIC value
}
\description{
Returns the AIC for an OpenMx model
helper function for \code{\link{logLik.MxModel}} (which enables AIC(model); logLik(model); BIC(model)
Original Author: brandmaier
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM", 
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
extractAIC(m1)
# -2.615998
AIC(m1)
}
\references{
- \url{http://openmx.psyc.virginia.edu/thread/931#comment-4858}
}
\seealso{
- \code{\link{AIC}}, \code{\link{umxCompare}}, \code{\link{logLik.MxModel}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{confint.MxModel}}, \code{\link{loadings}},
  \code{\link{logLik.MxModel}}, \code{\link{plot.MxModel}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxExpCov}},
  \code{\link{umxExpMeans}}, \code{\link{umxFitIndices}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACE}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACE}}, \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}

