% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umx_APA_pval}
\alias{umx_APA_pval}
\title{umx_APA_pval}
\usage{
umx_APA_pval(p, min = 0.001, rounding = 3, addComparison = NA)
}
\arguments{
\item{p}{The p-value to round}

\item{min}{Values below min reported as "< min"}

\item{rounding}{Number of decimal to which to round}

\item{addComparison}{Whether to add '=' '<' etc. (NA adds when needed)}
}
\value{
- formatted p-value
}
\description{
round a p value so you get < .001 instead of .000000002 or 1.00E-09
}
\examples{
umx_APA_pval(.052347)
umx_APA_pval(1.23E-3)
umx_APA_pval(1.23E-4)
umx_APA_pval(c(1.23E-3, .5))
umx_APA_pval(c(1.23E-3, .5), addComparison = TRUE)
}
\seealso{
- \code{\link{round}}

Other Reporting Functions: \code{\link{summaryAPA}},
  \code{\link{umx_aggregate}}, \code{\link{umx_print}},
  \code{\link{umx_show}}, \code{\link{umx_time}},
  \code{\link{umx}}
}

