% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxSummaryACE}
\alias{umxSummary.MxModel.ACE}
\alias{umxSummaryACE}
\title{umxSummaryACE}
\usage{
umxSummaryACE(model, digits = 2, dotFilename = NULL, returnStd = FALSE,
  extended = FALSE, showRg = FALSE, showStd = TRUE, comparison = NULL,
  CIs = TRUE, zero.print = ".", report = 1, ...)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to summarize}

\item{digits}{rounding (default = 2)}

\item{dotFilename}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{returnStd}{Whether to return the standardized form of the model (default = F)}

\item{extended}{how much to report (F)}

\item{showRg}{= whether to show the genetic correlations (F)}

\item{showStd}{= whether to show the standardized model (T)}

\item{comparison}{you can run mxCompare on a comparison model (NULL)}

\item{CIs}{Whether to show Confidence intervals if they exist (T)}

\item{zero.print}{How to show zeros (".")}

\item{report}{If 3, then open an html table of the results}

\item{...}{Other parameters to control model summary}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarise a Cholesky model, as returned by umxACE
}
\examples{
require(OpenMx)
data(twinData)
labList = c("MZFF", "MZMM", "DZFF", "DZMM", "DZOS")
twinData$ZYG = factor(twinData$zyg, levels = 1:5, labels = labList)
selDVs = c("bmi1", "bmi2")
mzData <- subset(twinData, ZYG == "MZFF", selDVs)
dzData <- subset(twinData, ZYG == "DZFF", selDVs)
m1 = umxACE(selDVs = selDVs, dzData = dzData, mzData = mzData)
m1 = umxRun(m1)
umxSummaryACE(m1)
\dontrun{
umxSummaryACE(m1, dotFilename = NA);
umxSummaryACE(m1, dotFilename = "name", showStd = TRUE)
stdFit = umxSummaryACE(m1, returnStd = TRUE);
}
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
- \code{\link{umxACE}}

Other Twin Reporting Functions: \code{\link{umx}},
  \code{\link{umx-package}}
}

