% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis.R
\name{ukb_icd_prevalence}
\alias{ukb_icd_prevalence}
\title{Returns the prevalence for an ICD diagnosis}
\usage{
ukb_icd_prevalence(data, icd.code, icd.version = 10)
}
\arguments{
\item{data}{A UKB dataset (or subset) created with \code{\link{ukb_df}}.}

\item{icd.code}{An ICD disease code e.g. "I74". Use a regular expression to specify a broader set of diagnoses, e.g. "I" captures all Diseases of the circulatory system, I00-I99, "C|D[0-4]." captures all Neoplasms, C00-D49.}

\item{icd.version}{The ICD version (or revision) number, 9 or 10. Default = 10.}
}
\description{
Returns the prevalence for an ICD diagnosis
}
\examples{
\dontrun{
# ICD-10 code I74, Arterial embolism and thrombosis
ukb_icd_prevalence(my_ukb_data, icd.version = 10, icd.diagnosis = "I74")

# ICD-10 chapter 9, disease block I00–I99, Diseases of the circulatory system
ukb_icd_prevalence(my_ukb_data, icd.version = 10, icd.diagnosis = "I")

# ICD-10 chapter 2, C00-D49, Neoplasms
ukb_icd_prevalence(my_ukb_data, icd.version = 10, icd.diagnosis = "C|D[0-4].")
}

}
\seealso{
\code{\link{ukb_icd_diagnosis}}, \code{\link{ukb_icd_code_meaning}}, \code{\link{ukb_icd_keyword}}
}
