% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/escapeRegex_(from_Hmisc).R
\name{escapeRegex}
\alias{escapeRegex}
\alias{escapeBS}
\title{Escapes any characters that would have special meaning in a reqular
expression.}
\usage{
escapeRegex(string)
}
\arguments{
\item{string}{string being operated on.}
}
\value{
The value of the string with any characters that would have special
meaning in a reqular expression escaped.
}
\description{
Escapes any characters that would have special meaning in a reqular
expression.
}
\details{
\code{escapeRegex} will escape any characters that would have special
meaning in a reqular expression. For any string
\code{grep(regexpEscape(string), string)} will always be true.
}
\note{
Note that this function was copied literally from the \code{Hmisc}
package (to prevent importing the entire package for one line of code).
}
\examples{

string <- "this\\\\(system) {is} [full]."
escapeRegex(string)
\dontshow{
if(!any(grep(escapeRegex(string), string))) {
  stop("function escapeRegex failed test")
}
}

}
\seealso{
\code{\link[base]{grep}}, \code{Hmisc},
\url{http://biostat.mc.vanderbilt.edu/wiki/Main/Hmisc},
\url{https://github.com/harrelfe/Hmisc}
}
\author{
Charles Dupont\cr Department of Biostatistics\cr Vanderbilt
University

Maintainer: Gjalt-Jorn Peters \href{mailto:gjalt-jorn@userfriendlyscience.com}{gjalt-jorn@userfriendlyscience.com}
}
\keyword{character}
\keyword{manip}
\keyword{programming}
