% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_set_rate}
\alias{system_set_rate}
\title{Set Infusion Rate Inputs}
\usage{
system_set_rate(cfg, rate, times, levels)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{rate}{name of infusion rate}

\item{times}{list of time values}

\item{levels}{corresponding list of infusion values}
}
\value{
Ubiquity system object with the infusion rate set
}
\description{
Defines infusion rates specified in the system file using  \code{<R:?>}
}
\examples{
\donttest{
# Creating a system file from the mab_pk example
fr = system_new(file_name        = "system.txt", 
                system_file      = "mab_pk", 
                overwrite        = TRUE, 
                output_directory = tempdir())

# Building the system 
cfg = build_system(system_file  = file.path(tempdir(), "system.txt"),
      output_directory          = file.path(tempdir(), "output"),
      temporary_directory       = tempdir())

# Clearing all inputs
cfg = system_zero_inputs(cfg)

# 5 minute infusion at 10 mg/min
cfg = system_set_rate(cfg,
           rate   = "Dinf",
           times  = c(0,  5), 
           levels = c(10, 0))
}
}
\seealso{
\code{\link{system_zero_inputs}}
}
