% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_log_init}
\alias{system_log_init}
\title{Initialize System Log File}
\usage{
system_log_init(cfg)
}
\arguments{
\item{cfg}{ubiquity system object}
}
\value{
ubiquity system object with logging enabled
}
\description{
Initializes the currently specified system log file.
}
\examples{
\donttest{
# Creating a system file from the mab_pk example
fr = system_new(file_name        = "system.txt", 
                system_file      = "mab_pk", 
                overwrite        = TRUE, 
                output_directory = tempdir())

# Building the system 
cfg = build_system(system_file  = file.path(tempdir(), "system.txt"),
      output_directory          = file.path(tempdir(), "output"),
      temporary_directory       = tempdir())

# Initialzing the log file
system_log_init(cfg)
}
}
