% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_glp_save}
\alias{system_glp_save}
\title{Save results from a GLP Study design}
\usage{
system_glp_save(
  cfg,
  study_name = "default",
  rptname = "default",
  output_directory = NULL,
  prefix = NULL
)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{study_name}{name of the study to save (\code{"default"})}

\item{rptname}{short name used to identify the report to attach results to the study in other functions (\code{default})}

\item{output_directory}{optional location to save results (default value of \code{NULL} will use the output folder specified at build time)}

\item{prefix}{optional string to prepend to files generated (default value of \code{NULL} will use \code{study_name})}
}
\value{
List with the following names
\itemize{
  \item{isgood} Boolean variable indicating success (\code{TRUE}) or failure (\code{FALSE})
  \item{files} List with names of the files exported and values containing the paths to the files
}
}
\description{
Saves files associated with a GLP study.
}
\seealso{
\code{\link{system_glp_init}}, \code{\link{system_glp_scenario}}
}
