% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_textures.R
\name{otb_stat}
\alias{otb_stat}
\title{Calculates local statistics for a given kernel size}
\usage{
otb_stat(
  input = NULL,
  out = "localStat",
  ram = "8192",
  radius = 3,
  channel = NULL,
  retRaster = FALSE,
  outDir = NULL,
  verbose = FALSE,
  otbLinks = NULL
)
}
\arguments{
\item{input}{of GeoTiff containing 1 ore more gray value bands}

\item{out}{string pattern vor individual naming of the output file(s)}

\item{ram}{reserved memory in MB}

\item{radius}{computational window in pixel}

\item{channel}{sequence of bands to be processed}

\item{retRaster}{boolean if TRUE a raster stack is returned}

\item{outDir}{output Directory}

\item{verbose}{switch for system messages default is FALSE}

\item{otbLinks}{list. of GI tools cli pathes}
}
\value{
raster* object
}
\description{
Calculates local statistics for a given kernel size
}
\note{
the otb is used for the calculation of the statistics. Please provide a GeoTiff file
}
\examples{
\dontrun{
# load libraries
require(uavRst)
require(link2GI)
require(listviewer)

setwd(tempdir())

# check if OTB exists
otbLinks <- link2GI::linkOTB()

if (otbLinks$exist) {
data("rgb")
raster::plotRGB(rgb)
fn<-file.path(tempdir(),"rgb.tif")
raster::writeRaster(rgb, 
                    filename=fn,
                    format="GTiff", 
                    overwrite=TRUE)
# get help
cmd<-link2GI::parseOTBFunction(algo = "LocalStatisticExtraction",gili=otbLinks)
listviewer::jsonedit(cmd$help)

# calculate statistics
result<- otb_stat(input=fn,
                  radius=5,
                  retRaster = TRUE,
                  channel = 1, 
                  otbLinks = otbLinks)
# plot the results :
raster::plot(result[[1]])
}
}
}
\author{
Chris Reudenbach
}
