% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_colorspace.R
\name{colorspace}
\alias{colorspace}
\title{imagemagick based function to transform the RGB color space into another}
\usage{
colorspace(
  input = NULL,
  colorspace = c("CIELab", "CMY", "Gray", "HCL", "HSB", "HSI", "Log", "XYZ", "YUV"),
  compress = "None",
  depth = 8,
  verbose = FALSE,
  retRaster = TRUE
)
}
\arguments{
\item{input}{character. name of a (Geo)Tiff containing RGB data channels}

\item{colorspace}{character. For a list of argument to determine colorspace see \href{https://www.imagemagick.org/script/command-line-options.php#colorspace}{colorspace manual}}

\item{compress}{character. compression type depending on the imagemagick version the choices are: None, BZip, Fax, Group4, JPEG, JPEG2000, Lossless, LZW, RLE or Zip.}

\item{depth}{numeric. color space depth in bit default is 8}

\item{verbose}{be quiet}

\item{retRaster}{logical if true a rasterstack is returned}
}
\value{
raster* object
}
\description{
Imagemagick is used for the calculation of the transformations. Please provide a tif file
}
\note{
you need to install imagemagick on your system, please look at see \href{https://www.imagemagick.org/script/download.php}{imagemagick download section}.
}
\examples{
\dontrun{

##- required packages
require(uavRst)
setwd(tempdir())
data("rgb")
raster::plotRGB(rgb)
fn<-file.path(tempdir(),"rgb.tif")
raster::writeRaster(rgb, 
                    filename=fn,
                    format="GTiff", 
                    overwrite=TRUE)
##- original color space
raster::plotRGB(raster::stack("rgb.tif"))
##- change colorspace from RGB to HSI
r2 <- colorspace(input="rgb.tif",colorspace="HSI")

##- visualize it
raster::plotRGB(r2)

##+}
}
