% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaldAndLR.R
\name{Wald_test}
\alias{Wald_test}
\title{Perform Wald test}
\usage{
Wald_test(gsmar, A, c, h = 6e-06)
}
\arguments{
\item{gsmar}{a class 'gsmar' object, typically generated by \code{fitGSMAR} or \code{GSMAR}.}

\item{A}{a size \eqn{(k x n_params)} matrix with full row rank specifying a part of the null hypothesis,
where \eqn{n_params} is the number of parameters in the (unconstrained) model.
See details for more information.}

\item{c}{a length \eqn{k} vector specifying a part of the null hypothesis. See details for more information.}

\item{h}{the difference used to approximate the derivatives.}
}
\value{
A list with class "htest" containing the following components:
  \item{statistic}{the value of the Wald statistics.}
  \item{parameter}{the degrees of freedom of the Wald statistic.}
  \item{p.value}{the p-value of the test.}
  \item{alternative}{a character string describing the alternative hypothesis.}
  \item{method}{a character string indicating the type of the test (Wald test).}
  \item{data.name}{a character string giving the names of the supplied model, constraint matrix A, and vector c.}
  \item{gsmar}{the supplied argument gsmar.}
  \item{A}{the supplied argument A.}
  \item{c}{the supplied argument c.}
  \item{h}{the supplied argument h.}
}
\description{
\code{Wald_test} performs a Wald test for a GMAR, StMAR, or G-StMAR model.
}
\details{
Denoting the true parameter value by \eqn{\theta_{0}}, we test the null hypothesis \eqn{A\theta_{0}=c}.
  Under the null, the test statistic is asymptotically \eqn{\chi^2}-distributed with \eqn{k}
  (\code{=nrow(A)}) degrees of freedom. The parameter \eqn{\theta_{0}} is assumed to have the same form as in
  the model supplied in the argument \code{gsmar} and it is presented in the documentation of the argument
  \code{params} in the function \code{GSMAR} (see \code{?GSMAR}).

  Note that this function does \strong{not} check whether the specified constraints are feasible (e.g., whether
  the implied constrained model would be stationary or have positive definite error term covariance matrices).
}
\examples{
\donttest{
# GMAR p=1, M=2 model:
fit12 <- fitGSMAR(simudata, p=1, M=2, model="GMAR", ncalls=1, seeds=1)

# Test with Wald test whether the AR coefficients are the same in both
# regimes:
# There are 7 parameters in the model and the AR coefficient of the
# first regime is the 2nd element, whereas the AR coefficient of the second
# regime is in the 5th element.
A <- matrix(c(0, 1, 0, 0, -1, 0, 0), nrow=1, ncol=7)
c <- 0
Wald_test(fit12, A=A, c=c)
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}(2), 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2023. A mixture autoregressive model based on Student's t-distribution.
         \emph{Communications in Statistics - Theory and Methods}, \strong{52}(2), 499-515.
   \item Virolainen S. 2022. A mixture autoregressive model based on Gaussian and Student's t-distributions.
         Studies in Nonlinear Dynamics & Econometrics, \strong{26}(4) 559-580.
 }
}
\seealso{
\code{\link{LR_test}}, \code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{diagnostic_plot}},
 \code{\link{profile_logliks}}, \code{\link{quantile_residual_tests}}, \code{\link{cond_moment_plot}}
}
