% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneticAlgorithm.R
\name{change_regime}
\alias{change_regime}
\title{Change the specified regime of parameter vector to the given regime-parameter vector}
\usage{
change_regime(
  p,
  M,
  params,
  model = c("GMAR", "StMAR", "G-StMAR"),
  restricted = FALSE,
  constraints = NULL,
  regime_params,
  regime
)
}
\arguments{
\item{p}{a positive integer specifying the autoregressive order of the model.}

\item{M}{\describe{
  \item{For \strong{GMAR} and \strong{StMAR} models:}{a positive integer specifying the number of mixture components.}
  \item{For \strong{G-StMAR} models:}{a size (2x1) integer vector specifying the number of \emph{GMAR type} components \code{M1} in the
   first element and \emph{StMAR type} components \code{M2} in the second element. The total number of mixture components is \code{M=M1+M2}.}
}}

\item{params}{a real valued parameter vector specifying the model.
 \describe{
   \item{For \strong{non-restricted} models:}{
     Size \eqn{(M(p+3)+M-M1-1x1)} vector \strong{\eqn{\theta}}\eqn{=}(\strong{\eqn{\upsilon_{1}}}\eqn{,...,}\strong{\eqn{\upsilon_{M}}},
     \eqn{\alpha_{1},...,\alpha_{M-1},}\strong{\eqn{\nu}}) where
     \itemize{
       \item \strong{\eqn{\upsilon_{m}}}\eqn{=(\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,}\eqn{\sigma_{m}^2)}
       \item \strong{\eqn{\phi_{m}}}\eqn{=(\phi_{m,1},...,\phi_{m,p}), m=1,...,M}
       \item \strong{\eqn{\nu}}\eqn{=(\nu_{M1+1},...,\nu_{M})}
       \item \eqn{M1} is the number of GMAR type regimes.
     }
     In the \strong{GMAR} model, \eqn{M1=M} and the parameter \strong{\eqn{\nu}} dropped. In the \strong{StMAR} model, \eqn{M1=0}.

     If the model imposes \strong{linear constraints} on the autoregressive parameters:
     Replace the vectors \strong{\eqn{\phi_{m}}} with the vectors \strong{\eqn{\psi_{m}}} that satisfy
      \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{C_{m}\psi_{m}}} (see the argument \code{constraints}).
     }
   \item{For \strong{restricted} models:}{
     Size \eqn{(3M+M-M1+p-1x1)} vector \strong{\eqn{\theta}}\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,}
     \eqn{\sigma_{1}^2,...,\sigma_{M}^2,}\eqn{\alpha_{1},...,\alpha_{M-1},}\strong{\eqn{\nu}}), where \strong{\eqn{\phi}}=\eqn{(\phi_{1},...,\phi_{p})}
     contains the AR coefficients, which are common for all regimes.

     If the model imposes \strong{linear constraints} on the autoregressive parameters:
     Replace the vector \strong{\eqn{\phi}} with the vector \strong{\eqn{\psi}} that satisfies
      \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{C\psi}} (see the argument \code{constraints}).
   }
 }
 Symbol \eqn{\phi} denotes an AR coefficient, \eqn{\sigma^2} a variance, \eqn{\alpha} a mixing weight, and \eqn{\nu} a degrees of
 freedom parameter. If \code{parametrization=="mean"}, just replace each intercept term \eqn{\phi_{m,0}} with the regimewise mean
 \eqn{\mu_m = \phi_{m,0}/(1-\sum\phi_{i,m})}. In the \strong{G-StMAR} model, the first \code{M1} components are \emph{GMAR type}
 and the rest \code{M2} components are \emph{StMAR type}.
 Note that in the case \strong{M=1}, the mixing weight parameters \eqn{\alpha} are dropped, and in the case of \strong{StMAR} or \strong{G-StMAR} model,
 the degrees of freedom parameters \eqn{\nu} have to be larger than \eqn{2}.}

\item{model}{is "GMAR", "StMAR", or "G-StMAR" model considered? In the G-StMAR model, the first \code{M1} components
are \emph{GMAR type} and the rest \code{M2} components are \emph{StMAR type}.}

\item{restricted}{a logical argument stating whether the AR coefficients \eqn{\phi_{m,1},...,\phi_{m,p}} are restricted
to be the same for all regimes.}

\item{constraints}{specifies linear constraints imposed to each regime's autoregressive parameters separately.
\describe{
\item{For \strong{non-restricted} models:}{a list of size \eqn{(pxq_{m})} constraint matrices \strong{\eqn{C_{m}}} of full column rank
  satisfying \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{C_{m}\psi_{m}}} for all \eqn{m=1,...,M}, where
  \strong{\eqn{\phi_{m}}}\eqn{=(\phi_{m,1},...,\phi_{m,p})} and \strong{\eqn{\psi_{m}}}\eqn{=(\psi_{m,1},...,\psi_{m,q_{m}})}.}
\item{For \strong{restricted} models:}{a size \eqn{(pxq)} constraint matrix \strong{\eqn{C}} of full column rank satisfying
  \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{C\psi}}, where \strong{\eqn{\phi}}\eqn{=(\phi_{1},...,\phi_{p})} and
  \strong{\eqn{\psi}}\eqn{=\psi_{1},...,\psi_{q}}.}
}
The symbol \eqn{\phi} denotes an AR coefficient. Note that regardless of any constraints, the autoregressive order
is always \code{p} for all regimes.
Ignore or set to \code{NULL} if applying linear constraints is not desired.}

\item{regime_params}{a numeric vector specifying the parameter values that should be inserted to the specified regime.
\describe{
  \item{For \strong{non-restricted} models:}{
    \describe{
      \item{For \strong{GMAR} model:}{Size \eqn{(p+2x1)} vector \eqn{(\phi_{m,0},\phi_{m,1},...,\phi_{m,p}, \sigma_{m}^2)}.}
      \item{For \strong{StMAR} model:}{Size \eqn{(p+3x1)} vector \eqn{(\phi_{m,0},\phi_{m,1},...,\phi_{m,p}, \sigma_{m}^2, \nu_{m})}.}
      \item{For \strong{G-StMAR} model:}{Same as GMAR for GMAR type regimes and same as StMAR for StMAR type regimes.}
      \item{With \strong{linear constraints}:}{Parameter vector as described above, but vector \strong{\eqn{\phi_{m}}} replaced with
       vector \strong{\eqn{\psi_{m}}} that satisfies \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{R_{m}\psi_{m}}}.}
    }
  }
  \item{For \strong{restricted} models:}{
    \describe{
      \item{For \strong{GMAR} model:}{Size \eqn{(2x1)} vector \eqn{(\phi_{m,0}, \sigma_{m}^2)}.}
      \item{For \strong{StMAR} model:}{Size \eqn{(3x1)} vector \eqn{(\phi_{m,0}, \sigma_{m}^2, \nu_{m})}.}
      \item{For \strong{G-StMAR} model:}{Same as GMAR for GMAR type regimes and same as StMAR for StMAR type regimes.}
      \item{With \strong{linear constraints}:}{Parameter vector as described above.}
    }
  }
}}

\item{regime}{a positive integer in the interval [1, M] defining which regime should be changed.}
}
\value{
Returns modified parameter vector of the form described in \code{params}.
}
\description{
\code{change_regime} changes the specified regime of the parameter vector to correspond the given
 regime-parameter vector and returns the modified parameter vector. Does not affect mixing weight parameters.
}
