% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAINest.R
\name{iterate_more}
\alias{iterate_more}
\title{Maximum likelihood estimation of GMAR, StMAR, or G-StMAR model with preliminary estimates}
\usage{
iterate_more(gsmar, maxit = 100, custom_h = NULL, calc_std_errors = TRUE)
}
\arguments{
\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{maxit}{the maximum number of iterations for the variable metric algorithm.}

\item{custom_h}{A numeric vector with same the length as the parameter vector: i:th element of custom_h is the difference
used in central difference approximation for partial differentials of the log-likelihood function for the i:th parameter.
If \code{NULL} (default), then the difference used for differentiating overly large degrees of freedom parameters
is adjusted to avoid numerical problems, and the difference is \code{6e-6} for the other parameters.}

\item{calc_std_errors}{should approximate standard errors be calculated?}
}
\value{
Returns an object of class \code{'gsmar'} defining the estimated model.
}
\description{
\code{iterate_more} uses a variable metric algorithm to finalize maximum likelihood
 estimation of a GMAR, StMAR or G-StMAR model (object of class \code{'gsmar'}) which already has
 preliminary estimates.
}
\details{
The main purpose of \code{iterate_more} is to provide a simple and convenient tool to finalize
  the estimation when the maximum number of iterations is reached when estimating a model with the
  main estimation function \code{fitGSMAR}. \code{iterate_more} is essentially a wrapper for the functions
  \code{optim} from the package \code{stats} and \code{GSMAR} from the package \code{uGMAR}.
}
\examples{
\donttest{
# Estimate GMAR model with only 50 generations of genetic algorithm and
# only 1 iteration in variable metric algorithm
fit13 <- fitGSMAR(T10Y1Y, 1, 3, maxit=1, ngen=50, ncalls=1, seeds=1)
fit13

# Iterate more since iteration limit was reached
fit13 <- iterate_more(fit13)
fit13
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item Virolainen S. 2020. A mixture autoregressive model based on Gaussian and Student's t-distribution.	arXiv:2003.05221 [econ.EM].
 }
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{stmar_to_gstmar}},
  \code{\link{profile_logliks}}, \code{\link{optim}}
}
