% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasources.R
\name{extract_datasource_details}
\alias{extract_datasource_details}
\title{Extract datasource details from a Tableau TWB}
\usage{
extract_datasource_details(xml_doc)
}
\arguments{
\item{xml_doc}{An \code{xml2} document for a Tableau \code{.twb}.}
}
\value{
A named list with:
\describe{
\item{data_sources}{Tibble of datasources joined with connection metadata.}
\item{parameters}{Tibble of parameter datasources (if present).}
\item{all_sources}{Same as \code{data_sources} (placeholder for future variants).}
}
}
\description{
Gathers runtime tables (from the object graph), merges in named connection
metadata (class, caption, targets), and augments with top-level datasource
definitions (field counts, connection type, location). Also returns a
filtered table of parameter datasources.
}
\examples{
# Preferred: from a tiny .twb
twb <- system.file("extdata", "test_for_wenjie.twb", package = "twbparser")
if (nzchar(twb) && file.exists(twb)) {
xml <- xml2::read_xml(twb)
res <- extract_datasource_details(xml)
head(res$data_sources)
}

# Alternative: from a tiny .twbx
twbx <- system.file("extdata", "test_for_zip.twbx", package = "twbparser")
if (nzchar(twbx) && file.exists(twbx)) {
members <- twbx_list(twbx)
twb_member <- members$Name[grepl("\\\\.twb$", members$Name)][1]
if (!is.na(twb_member)) {
xml <- xml2::read_xml(unz(twbx, twb_member))
res <- extract_datasource_details(xml)
head(res$data_sources)
  }
}


}
