% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dx.wts.mediation.R
\name{dx.wts.mediation}
\alias{dx.wts.mediation}
\title{Compute diagnostics assessing covariates balance.}
\usage{
dx.wts.mediation(
  x,
  data,
  estimand,
  vars = NULL,
  treat.var,
  x.as.weights = TRUE,
  sampw = NULL,
  perm.test.iters = 0
)
}
\arguments{
\item{x}{A data frame, matrix, or vector of propensity score weights or a ps
object. \code{x} can also be a data frame, matrix, or vector of
propensity scores if \code{x.as.weights=FALSE}.}

\item{data}{A data frame.}

\item{estimand}{The estimand of interest: either "ATT" or "ATE".}

\item{vars}{A vector of character strings naming variables in \code{data} on
which to assess balance.}

\item{treat.var}{A character string indicating which variable in \code{data}
contains the 0/1 treatment group indicator.}

\item{x.as.weights}{\code{TRUE} or \code{FALSE} indicating whether \code{x}
specifies propensity score weights or propensity scores.
Ignored if \code{x} is a ps object. Default: \code{TRUE}.}

\item{sampw}{Optional sampling weights. If \code{x} is a \code{ps} object, then the
sampling weights should have been passed to \link{ps} and
not specified here. \code{dx.wts.mediation} will issue a warning if
\code{x} is a ps object and \code{sampw} is also specified.}

\item{perm.test.iters}{A non-negative integer giving the number of iterations
of the permutation test for the KS statistic. If \code{perm.test.iters=0},
then the function returns an analytic approximation to the p-value. This
argument is ignored is \code{x} is a \code{ps} object. Setting
\code{perm.test.iters=200} will yield precision to within 3\% if the true
p-value is 0.05. Use \code{perm.test.iters=500} to be within 2\%.}
}
\value{
Returns a list containing
\itemize{
\item \code{treat} The vector of 0/1 treatment assignment indicators.
}
}
\description{
\code{dx.wts.mediation} takes a \code{ps} object or a set of propensity scores and
computes diagnostics assessing covariates balance.
}
\details{
Creates a balance table that compares unweighted and weighted means and
standard deviations, computes effect sizes, and KS statistics to assess the
ability of the propensity scores to balance the treatment and control groups.
}
\examples{
data("tMdat")

## tMdat is small simulated data set included in twangMediation for 
## demonstrating the functions. See ?tMdat for details

fit.es.max <- wgtmed(M ~ w1 + w2 + w3,
                      data = tMdat,
                      a_treatment = "A",
                      y_outcome = "Y",
                      total_effect_wts = tMdat$te.wgt,
                      method = "ps",
                      ps_n.trees=1500,
                      ps_shrinkage=0.01,
                      ps_stop.method=c("es.max")
                      )

## dx.wts.mediation is used internally by bal.table.mediation,
##   print.mediation, and summary.mediation

summary(fit.es.max)
}
\seealso{
\code{\link{wgtmed},\link{bal.table.mediation},
  \link{print.mediation},\link{summary.mediation}}
}
