% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectations.R
\name{expect_equal_with_diff}
\alias{expect_equal_with_diff}
\alias{expect_equivalent_with_diff}
\title{Test for equality with explicit difference}
\usage{
expect_equal_with_diff(
  current,
  target,
  tol = sqrt(.Machine$double.eps),
  mode = getOption("diffobj.mode", "unified"),
  format = getOption("diffobj.format", "ansi256"),
  ...
)

expect_equivalent_with_diff(
  current,
  target,
  tol = sqrt(.Machine$double.eps),
  ...
)
}
\arguments{
\item{current}{\code{[R object or expression]} Outcome or expression under scrutiny.}

\item{target}{\code{[R object or expression]} Expected outcome}

\item{tol}{\code{[numeric]} Test equality to machine rounding. Passed
to \code{\link[base]{all.equal} (tolerance)}}

\item{mode}{\code{[character]} Comparison mode passed to \code{diffPrint},
defaults to using the \dQuote{diffobj.mode} global option value with
\dQuote{unified} as fallback if no such option is set}

\item{format}{\code{[character]} Comparison mode passed to \code{diffPrint},
defaults to to using the \dQuote{diffobj.format} global option value with
\dQuote{raw} as fallback if no such option is set}

\item{...}{Passed to \code{all.equal}}
}
\value{
A \code{\link{tinytest}} object. A tinytest object is a
\code{logical} with attributes holding information about the
test that was run
}
\description{
Test for equality with explicit difference
}
\details{
\code{expect_equivalent_with_diff} calls
\code{expect_equal_with_diff} with the extra arguments
\code{check.attributes=FALSE} and \code{use.names=FALSE}
}
\examples{
library(tinytest)
using(ttdo)
expect_equal_with_diff(1 + 1, 2)		# TRUE
expect_equal_with_diff(1 - 1, 2)		# FALSE
expect_equivalent_with_diff(2, c(x=2))	# TRUE
expect_equivalent_with_diff(2, c(x=2))	# TRUE
}
