% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggts.R
\name{aggts}
\alias{aggts}
\title{Aggregates a \code{tsvreq_classic} object across a set of timescales; also the constructor function
for class \code{vreq_classic_ag}.}
\usage{
aggts(obj, ts)
}
\arguments{
\item{obj}{A \code{tsvreq_classic} object}

\item{ts}{The timescales to aggregate over}
}
\value{
\code{aggts} returns an object of class \code{vreq_classic_ag}. Slots are:
\item{com}{the timescale-aggregated value of CVcom2}
\item{comnull}{the timescale-aggregated value of CVcomip2}
\item{vr}{the timescale-aggregated value of the classic variance ratio}
\item{ts}{the timescales over which aggregation was performed}
}
\description{
All the components of a \code{tsvreq_classic} object can be aggregated across an arbitrary 
set of timescales, producing a new variance ratio equation - this function performs that
aggregation. The function returns a \code{vreq_classic_ag} object, and is the constructor 
function of that class. The 
\code{vreq_classic_ag} class has slots \code{com}, \code{comnull}, \code{vr}, which are
the same as a \code{vreq} object, but also has slot \code{ts}, which is the timescales
over which aggregation was performed to get the object. The class inherits from \code{vreq},
which inherits from \code{list}.
}
\details{
Before aggregation is performed, the argument `ts` is intersected with the 
canonical Fourier timescales greater than or equal to the Nyquist timescale, and the
resulting timescales are then reflected about the Nyquist timescale. This is to 
account for the symmetry of Fourier transforms about the Nyquist frequency. The
`ts` slot of the output object shows the intersected, reflected timescales that were 
actually used for aggregation. See the examples.
}
\examples{
X<-matrix(runif(10*100),10,100)
h<-tsvreq_classic(X)
res1<-aggts(h,h$ts[h$ts>=4]) 
res2<-aggts(h,h$ts[h$ts>=4 | h$ts<=4/3]) 
#res1 and res2 produce the same result 
#because of Fourier symmetry around the 
#Nyquist timescale - see Details 

}
\references{
Zhao et al, (In prep) Decomposition of the variance ratio illuminates timescale-specific
population and community variability.
}
\seealso{
\code{\link{tsvreq_classic}}, \code{\link{vreq_classic_ag_methods}}, 
\code{browseVignettes("tsvr")}
}
\author{
Shaopeng Wang, \email{shaopeng.wang@pku.edu.cn}; Lei Zhao, \email{lei.zhao@cau.edu.cn}; Daniel Reuman, \email{reuman@ku.edu}
}
