% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{av_stop_word}
\alias{av_stop_word}
\title{Computes the annotation vector that suppresses stop-word motifs}
\usage{
av_stop_word(.mp, data, stop_word_loc, exclusion_zone = NULL,
  threshold = 0.1, apply = FALSE)
}
\arguments{
\item{.mp}{a Matrix Profile object.}

\item{data}{a \code{vector} or a column \code{matrix} of \code{numeric}.}

\item{stop_word_loc}{an \code{int}. The index of stop word location.}

\item{exclusion_zone}{a \code{numeric}. Size of the exclusion zone, based on window_size (default is
\code{NULL}). See details.}

\item{threshold}{a \code{numeric}. (default is \code{0.1}).}

\item{apply}{logical. (Default is \code{FALSE}). Applies the Annotation Vector over the Matrix Profile.
Use with caution.}
}
\value{
Returns the input \code{.mp} object with an embedded annotation vector.
}
\description{
Computes the annotation vector that suppresses stop-word motifs
}
\details{
The function is intended to be generic. However, its parameters (\code{stop_word_loc},
\code{exclusion_zone} and \code{threshold}) are highly dataset dependent.
}
\examples{
data <- mp_test_data$train$data[1:1000]
w <- 50
mp <- tsmp(data, window_size = w, verbose = 0)
av <- av_stop_word(mp, stop_word_loc = 150, apply = TRUE)
}
\references{
\itemize{
\item Dau HA, Keogh E. Matrix Profile V: A Generic Technique to Incorporate Domain
Knowledge into Motif Discovery. In: Proceedings of the 23rd ACM SIGKDD International Conference
on Knowledge Discovery and Data Mining - KDD ’17. New York, New York, USA: ACM Press; 2017. p.
125–34.
}
}
\seealso{
Other Annotation vectors: \code{\link{av_apply}},
  \code{\link{av_complexity}},
  \code{\link{av_hardlimit_artifact}},
  \code{\link{av_motion_artifact}},
  \code{\link{av_zerocrossing}}
}
\concept{Annotation vectors}
