% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m_guide_search.R
\name{guide.search}
\alias{guide.search}
\title{Guided MOTIF Discovery for Multidimensional Matrix Profile}
\usage{
guide.search(data, window.size, matrix.profile, profile.index, n.dim)
}
\arguments{
\item{data}{a \code{matrix} of \code{numeric}, where each colums is a time series. Accepts \code{vector} (see details), \code{list} and \code{data.frame} too.}

\item{window.size}{an \code{int} with the size of the sliding window.}

\item{matrix.profile}{multidimensional matrix profile (matrix)}

\item{profile.index}{multidimensional profile index (from \code{\link[=mstomp]{mstomp()}} or \code{\link[=mstomp.par]{mstomp.par()}}).}

\item{n.dim}{an \code{int}. The dimensionality of the MOTIF to find.}
}
\value{
Returns the \code{motif.idx} with the index of MOTIFs founded and \code{motif.dim}
with the spanned dimensions of respective MOTIF.
}
\description{
Guided MOTIF Discovery for Multidimensional Matrix Profile
}
\details{
Although this functions handles Multivariate Time Series, it can also be used to handle Univariate Time Series.
}
\examples{
# This is a fast toy example and results are useless. For a complete result, run the code inside
#'Not run' section below.
w <- toy_data$sub.len
mp <- mstomp(toy_data$data[1:200,], w, verbose = 0)
motifs <- guide.search(toy_data$data[1:200,], w, mp$mp, mp$pi, 2)
\dontrun{
w <- toy_data$sub.len
mp <- mstomp.par(toy_data$data, w, verbose = 0)
motifs <- guide.search(toy_data$data, w, mp$mp, mp$pi, 2)
}
}
\references{
\enumerate{
\item Yeh CM, Kavantzas N, Keogh E. Matrix Profile VI : Meaningful Multidimensional Motif Discovery.
}

\enumerate{
\item Zhu Y, Imamura M, Nikovski D, Keogh E. Matrix Profile VII: Time Series Chains: A New Primitive for Time Series Data Mining. Knowl Inf Syst. 2018 Jun 2;1–27.
}

Website: \url{https://sites.google.com/view/mstamp/}

Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
\seealso{
\code{\link[=mstomp]{mstomp()}}, \code{\link[=mstomp.par]{mstomp.par()}}, \code{\link[=unconstrain.search]{unconstrain.search()}}

Other mstomp: \code{\link{mstomp.par}},
  \code{\link{mstomp}}, \code{\link{unconstrain.search}}
}
\concept{mstomp}
