context("as_tsibble() for ts objects")

test_that("a ts with different frequnecy", {
  x1 <- ts(1:10)
  tsbl1 <- as_tsibble(x1)
  expect_identical(dim(tsbl1), c(length(x1), 2L))
  expect_identical(key_vars(tsbl1), character(0))
  expect_identical(format(interval(tsbl1)), "1")
  x2 <- ts(1:10, start = 2000)
  tsbl2 <- as_tsibble(x2)
  expect_identical(format(interval(tsbl2)), "1Y")
  x3 <- ts(1:10, start = c(2000, 1), frequency = 4)
  tsbl3 <- as_tsibble(x3)
  expect_identical(format(interval(tsbl3)), "1Q")
  x4 <- ts(1:10, start = c(2000, 1), frequency = 12)
  tsbl4 <- as_tsibble(x4)
  expect_identical(format(interval(tsbl4)), "1M")
  x5 <- ts(1:10, start = c(2000, 1), frequency = 7)
  tsbl5 <- as_tsibble(x5)
  expect_identical(format(interval(tsbl5)), "1D")
  x6 <- ts(1:10, start = c(2000, 1), frequency = 52)
  expect_warning(tsbl6 <- as_tsibble(x6), "Expected frequency")
  x7 <- ts(1:10, start = c(2000, 1), frequency = 52.18)
  tsbl7 <- as_tsibble(x7)
  expect_identical(format(interval(tsbl7)), "1W")
})

test_that("a mts", {
  x <- ts(matrix(1:10, ncol = 2))
  tsbl1 <- as_tsibble(x)
  expect_identical(dim(tsbl1), c(length(x), 3L))
  expect_identical(key_vars(tsbl1)[[1L]], "key")
  tsbl2 <- as_tsibble(x, pivot_longer = FALSE)
  expect_identical(dim(tsbl2), c(nrow(x), 3L))
  expect_identical(key_vars(tsbl2), character(0))
  expect_identical(colnames(tsbl2), c("index", "Series 1", "Series 2"))
})

test_that("time floating #128", {
  x <- ts(1:134, start = c(1960, 11), frequency = 12)
  expect_true(anyDuplicated(as_tsibble(x)$index) == 0)
})
