% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stretch.R
\name{stretch_tsibble}
\alias{stretch_tsibble}
\title{Perform stretching windows on a tsibble by row}
\usage{
stretch_tsibble(.x, .step = 1, .init = 1, .id = ".id")
}
\arguments{
\item{.x}{A tsibble.}

\item{.step}{A positive integer for incremental step.}

\item{.init}{A positive integer for an initial window size.}

\item{.id}{A character naming the new column \code{.id} containing the partition.}
}
\description{
\lifecycle{questioning}
}
\section{Rolling tsibble}{

\code{slide_tsibble()}, \code{tile_tsibble()}, and \code{stretch_tsibble()} provide fast
and shorthand for rolling over a tsibble by observations. That said, if the
supplied tsibble has time gaps, these rolling helpers will ignore those gaps
and proceed.

They are useful for preparing the tsibble for time series cross validation.
They all return a tsibble including a new column \code{.id} as part of the key. The
output dimension will increase considerably with \code{slide_tsibble()} and
\code{stretch_tsibble()}, which is likely to run out of memory when the data is
large. Alternatively, you could construct cross validation using \code{pslide()}
and \code{pstretch()} to avoid the memory issue.
}

\examples{
harvest <- tsibble(
  year = rep(2010:2012, 2),
  fruit = rep(c("kiwi", "cherry"), each = 3),
  kilo = sample(1:10, size = 6),
  key = fruit, index = year
)
harvest \%>\%
  stretch_tsibble()
}
\seealso{
Other rolling tsibble: \code{\link{slide_tsibble}},
  \code{\link{tile_tsibble}}
}
\concept{rolling tsibble}
