% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index-by.R
\name{index_by}
\alias{index_by}
\title{Group and collapse by time index}
\usage{
index_by(.data, ...)
}
\arguments{
\item{.data}{A \code{tbl_ts}.}

\item{...}{A single name-value pair of expression: a new index on LHS and the
current index on RHS. Or an existing variable to be used as index.
The index functions that can be used, but not limited:
\itemize{
\item \link[lubridate:year]{lubridate::year}: yearly aggregation
\item \link{yearquarter}: quarterly aggregation
\item \link{yearmonth}: monthly aggregation
\item \link{yearweek}: weekly aggregation
\item \link{as.Date} or \link[lubridate:as_date]{lubridate::as_date}: daily aggregation
\item \link[lubridate:ceiling_date]{lubridate::ceiling_date}, \link[lubridate:floor_date]{lubridate::floor_date}, or \link[lubridate:round_date]{lubridate::round_date}:
fine-resolution aggregation
\item other index functions from other packages
}}
}
\description{
\code{index_by()} is the counterpart of \code{group_by()} in temporal context, but it
only groups the time index. It adds a new column and then group it. The
following operation is applied to each group of the index, similar to
\code{group_by()} but dealing with index only. \code{index_by()} + \code{summarise()} will
update the grouping index variable to be the new index. Use \code{ungroup()} or
\code{index_by()} with no arguments to remove the index grouping vars.
}
\details{
\itemize{
\item A \code{index_by()}-ed tsibble is indicated by \code{@} in the "Groups" when
displaying on the screen.
}
}
\examples{
# Monthly counts across sensors
library(dplyr, warn.conflicts = FALSE)
monthly_ped <- pedestrian \%>\% 
  group_by(Sensor) \%>\% 
  index_by(Year_Month = yearmonth(Date_Time)) \%>\%
  summarise(
    Max_Count = max(Count),
    Min_Count = min(Count)
  )
monthly_ped
index(monthly_ped)

# Using existing variable
pedestrian \%>\% 
  group_by(Sensor) \%>\% 
  index_by(Date) \%>\%
  summarise(
    Max_Count = max(Count),
    Min_Count = min(Count)
  )

# Attempt to aggregate to 4-hour interval, with the effects of DST
pedestrian \%>\% 
  group_by(Sensor) \%>\% 
  index_by(Date_Time4 = lubridate::floor_date(Date_Time, "4 hour")) \%>\%
  summarise(Total_Count = sum(Count))

# Annual trips by Region and State
tourism \%>\% 
  index_by(Year = lubridate::year(Quarter)) \%>\% 
  group_by(Region, State) \%>\% 
  summarise(Total = sum(Trips))
}
