% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-tsibble.R
\name{as_tibble.tbl_ts}
\alias{as_tibble.tbl_ts}
\alias{as.data.frame.tbl_ts}
\title{Coerce to a tibble or data frame}
\usage{
\method{as_tibble}{tbl_ts}(x, ...)

\method{as.data.frame}{tbl_ts}(x, row.names = NULL, optional = FALSE,
  ...)
}
\arguments{
\item{x}{A \code{tbl_ts}.}

\item{...}{Ignored.}

\item{row.names}{\code{NULL} or a character vector giving the row
    names for the data frame.  Missing values are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and
    converting column names (to syntactic names: see
    \code{\link{make.names}}) is optional.  Note that all of \R's
    \pkg{base} package \code{as.data.frame()} methods use
    \code{optional} only for column names treatment, basically with the
    meaning of \code{\link{data.frame}(*, check.names = !optional)}.
    See also the \code{make.names} argument of the \code{matrix} method.}
}
\description{
Coerce to a tibble or data frame
}
\examples{
as_tibble(pedestrian)

# a grouped tbl_ts -----
grped_ped <- pedestrian \%>\% group_by(Sensor)
as_tibble(grped_ped)
}
