% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stretch.R
\name{stretcher}
\alias{stretcher}
\alias{pstretcher}
\title{Split the input to a list according to the stretching window size.}
\usage{
stretcher(.x, .size = 1, .init = 1, .bind = FALSE)

pstretcher(..., .size = 1, .init = 1, .bind = FALSE)
}
\arguments{
\item{.x}{An objects to be split.}

\item{.size}{An integer for window size. If positive, moving forward from left
to right; if negative, moving backward (from right to left).}

\item{.init}{A positive integer for an initial window size.}

\item{.bind}{If \code{.x} is a list, should \code{.x} be combined before applying \code{.f}?
If \code{.x} is a list of data frames, row binding is carried out.}

\item{...}{Multiple objects to be split in parallel.}
}
\description{
Split the input to a list according to the stretching window size.
}
\examples{
x <- 1:5
y <- 6:10
z <- 11:15
lst <- list(x = x, y = y, z = z)
df <- as.data.frame(lst)

stretcher(x, .size = 2)
stretcher(lst, .size = 2)
stretcher(df, .size = 2)
pstretcher(df, df, .size = 2)
}
