% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr-verbs.R
\name{spread.tbl_ts}
\alias{spread.tbl_ts}
\title{Spread a key-value pair across multiple columns.}
\usage{
\method{spread}{tbl_ts}(data, key, value, fill = NA, convert = FALSE,
  drop = TRUE, sep = NULL)
}
\arguments{
\item{data}{A \code{tbl_ts}.}

\item{key}{Column names or positions. This is passed to
\code{\link[tidyselect:vars_pull]{tidyselect::vars_pull()}}.

These arguments are passed by expression and support
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names or column positions).}

\item{value}{Column names or positions. This is passed to
\code{\link[tidyselect:vars_pull]{tidyselect::vars_pull()}}.

These arguments are passed by expression and support
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names or column positions).}

\item{fill}{If set, missing values will be replaced with this value. Note
that there are two types of missingness in the input: explicit missing
values (i.e. \code{NA}), and implicit missings, rows that simply aren't
present. Both types of missing value will be replaced by \code{fill}.}

\item{convert}{If \code{TRUE}, \code{\link[=type.convert]{type.convert()}} with \code{asis =
  TRUE} will be run on each of the new columns. This is useful if the value
column was a mix of variables that was coerced to a string. If the class of
the value column was factor or date, note that will not be true of the new
columns that are produced, which are coerced to character before type
conversion.}

\item{drop}{If \code{FALSE}, will keep factor levels that don't appear in the
data, filling in missing combinations with \code{fill}.}

\item{sep}{If \code{NULL}, the column names will be taken from the values of
\code{key} variable. If non-\code{NULL}, the column names will be given
by "<key_name><sep><key_value>".}
}
\description{
Spread a key-value pair across multiple columns.
}
\examples{
# example from tidyr
stocks <- tsibble(
  time = as.Date('2009-01-01') + 0:9,
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4)
)
stocksm <- stocks \%>\% gather(stock, price, -time)
stocksm \%>\% spread(stock, price)
}
\seealso{
\link[tidyr:spread]{tidyr::spread}
}
