% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-tsibble.R
\name{inform_duplicates}
\alias{inform_duplicates}
\title{Inform duplication of key and index variables}
\usage{
inform_duplicates(data, key = id(), index, fromLast = FALSE)
}
\arguments{
\item{data}{A \code{tbl_ts} object.}

\item{key}{Structural variable(s) that define unique time indices, used with
the helper \link{id}. If a univariate time series (without an explicit key),
simply call \code{id()}.}

\item{index}{A bare (or unquoted) variable to specify the time index variable.}

\item{fromLast}{\code{TRUE} does the duplication check from the last of identical
elements.}
}
\value{
A logical vector of the same length as the row number of \code{data}
}
\description{
Inform which row has duplicated key and index elements
}
