% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runtsir_function.R
\name{runtsir}
\alias{runtsir}
\title{runtsir}
\usage{
runtsir(data, xreg = "cumcases", IP = 2, nsim = 10,
  regtype = "gaussian", sigmamax = 3, userYhat = numeric(),
  alpha = NULL, sbar = NULL, family = "gaussian", link = "identity",
  method = "deterministic", inits.fit = FALSE, epidemics = "cont",
  pred = "forward", threshold = 1, seasonality = "standard",
  add.noise.sd = 0, mul.noise.sd = 0, printon = F, fit = NULL,
  fittype = NULL)
}
\arguments{
\item{data}{The data frame containing cases and interpolated births and populations.}

\item{xreg}{The x-axis for the regression. Options are 'cumcases' and 'cumbirths'. Defaults to 'cumcases'.}

\item{IP}{The infectious period in weeks. Defaults to 2 weeks.}

\item{nsim}{The number of simulations to do. Defaults to 100.}

\item{regtype}{The type of regression used in susceptible reconstruction.
Options are 'gaussian', 'lm' (linear model), 'spline' (smooth.spline with 2.5 degrees freedom),
'lowess' (with f = 2/3, iter = 1), 'loess' (degree 1), and 'user' which is just a user inputed vector.
Defaults to 'gaussian' and if that fails then defaults to loess.}

\item{sigmamax}{The inverse kernal width for the gaussian regression. Default is 3.
Smaller, stochastic outbreaks tend to need a lower sigma.}

\item{userYhat}{The inputed regression vector if regtype='user'. Defaults to NULL.}

\item{alpha}{The mixing parameter. Defaults to NULL, i.e. the function estimates alpha.}

\item{sbar}{The mean number of susceptibles. Defaults to NULL, i.e. the function estimates sbar.}

\item{family}{The family in the GLM regression. One can use any of the GLM ones, but the options are essentially
'poisson' (with link='log'), 'gaussian' (with link='log' or 'identity'), or 'quasipoisson' (with link='log'). Default is 'gaussian'.}

\item{link}{The link function used with the glm family. Options are link='log' or 'identity'. Default is 'identity'.}

\item{method}{The type of next step prediction used. Options are 'negbin' for negative binomial,
'pois' for poisson distribution, and 'deterministic'. Defaults to 'deterministic'.}

\item{inits.fit}{Whether or not to fit initial conditions using simple least squares as well. Defaults to FALSE. This parameter is more necessary in more chaotic locations.}

\item{epidemics}{The type of data splitting. Options are 'cont' which doesn't split the data up at all,
and 'break' which breaks the epidemics up if there are a lot of zeros. Defaults to 'cont'.}

\item{pred}{The type of prediction used. Options are 'forward' and 'step-ahead'. Defaults to 'forward'.}

\item{threshold}{The cut off for a new epidemic if epidemics = 'break'. Defaults to 1.}

\item{seasonality}{The type of contact to use. Options are standard for 52/IP point contact or schoolterm for just a two point on off contact, or none for a single contact parameter. Defaults to standard.}

\item{add.noise.sd}{The sd for additive noise, defaults to zero.}

\item{mul.noise.sd}{The sd for multiplicative noise, defaults to zero.}

\item{printon}{Whether to show diagnostic prints or not, defaults to FALSE.}

\item{fit}{Now removed but gives a warning.}

\item{fittype}{Now removed but gives a warning.}
}
\description{
This function runs the TSIR model.
}
\examples{
require(kernlab)
London <- twentymeas[["London"]]
\dontrun{
plotdata(London)
res <- runtsir(data=London,method='pois',nsim=10, IP=2,inits.fit=FALSE)
plotres(res)
}
}

