% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca-classes-methods.r
\docType{class}
\name{constructive_aggregation-class}
\alias{constructive_aggregation-class}
\title{constructive_aggregation-class}
\description{
Constructive aggregation via out-performance contiguity
This method denotes the idea of rearranging a portfolio of
models (\strong{base_ensemble}) into different overlapping
subsets. These subsets are aggregated (\strong{aggregate_subsets})
into combined opinions, forming new models. These models
are combined into a final decision through \strong{aggregate_hypos}.
}
\section{Slots}{

\describe{
\item{\code{base_ensemble}}{object of class \code{\link{base_ensemble-class}}.
It contains the base models used that can be used for predicting
new data or forecasting future values;}

\item{\code{committee_set}}{a list of ids -- the individual models
of each subset;}

\item{\code{form}}{formula;}

\item{\code{specs}}{object of class \code{\link{model_specs-class}}. Contains
the parameter setting information for training the
base models;}

\item{\code{lambda}}{window size used to average loss. How far to
to back in time.}

\item{\code{alpha}}{contiguity size. How long should a subset
outperform other for it to be considered in the committee}

\item{\code{recent_series}}{the most recent \code{lambda} observations.}

\item{\code{out_of_bag}}{Out of bag observations used to compute
the subsets}

\item{\code{aggregate_subsets}}{aggregation approach for the set of subsets.}

\item{\code{aggregate_hypos}}{final aggregation approach. How should the
combined opinions be aggregated.}
}}

\keyword{internal}
