% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/margins.R
\name{fit,margin-method}
\alias{fit,margin-method}
\title{Fit method for margin class}
\usage{
\S4method{fit}{margin}(x, y, tsoptions = list(), control = list(maxit = 1000))
}
\arguments{
\item{x}{an object of class \linkS4class{margin}.}

\item{y}{a vector or time series of data.}

\item{tsoptions}{list of optional arguments:
hessian is logical variable specifying whether Hessian matrix should be returned;
start is vector od named starting values}

\item{control}{list of control parameters to be passed to the
\code{\link[stats]{optim}} function.}
}
\value{
An object of class \linkS4class{marginfit}.
}
\description{
Fit method for margin class
}
\examples{
margmod <- margin("norm", pars = c(mean = 0, sd = 1))
data <- sim(margmod, n = 500)
fit(margmod, data)
}
