% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_index.R
\name{ts_index}
\alias{ts_index}
\alias{ts_compound}
\title{Indices from Levels or Percentage Rates}
\usage{
ts_compound(x, denominator = 100)

ts_index(x, base = NULL)
}
\arguments{
\item{x}{ts-boxable time series, an object of class \code{ts}, \code{xts}, \code{zoo},
\code{zooreg}, \code{data.frame}, \code{data.table}, \code{tbl}, \code{tbl_ts}, \code{tbl_time}, \code{tis},
\code{irts} or \code{timeSeries}.}

\item{denominator}{positive number. Set equal to 1 if percentage change rate is
given a decimal fraction}

\item{base}{base date, character string, \code{Date} or \code{POSIXct}, at which the
index is set to 1. If two dates are provided, the mean in the range is
set equal to 1 (see examples).}
}
\value{
a ts-boxable object of the same class as \code{x}, i.e., an object of
class \code{ts}, \code{xts}, \code{zoo}, \code{zooreg}, \code{data.frame}, \code{data.table}, \code{tbl},
\code{tbl_ts}, \code{tbl_time}, \code{tis}, \code{irts} or \code{timeSeries}.
}
\description{
\code{ts_index} returns an indexed series, with value of 1 at the \code{base} date or
range.
\code{ts_compound} builds an index from percentage change rates, starting with 1
and compounding the rates.
}
\examples{
x <- ts_pc(ts_c(fdeaths, mdeaths))
ts_compound(x)
y <- ts_df(ts_c(fdeaths, mdeaths))
ts_index(y, "1974-02-01")
\donttest{
ts_plot(
  `My Expert Knowledge` = ts_chain(
    mdeaths,
    ts_compound(ts_bind(ts_pc(mdeaths), 15, 23, 33))
  ),
  `So Far` = mdeaths,
  title = "A Very Manual Forecast"
)

# mean of 1974 = 1
ts_index(mdeaths, c("1974-01-01", "1974-12-31"))
}
}
