% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf.linear.R, R/irf.nlVar.R
\name{irf.linear}
\alias{irf.linear}
\alias{irf.setar}
\alias{irf.ar}
\alias{irf.VAR}
\alias{irf.nlVar}
\alias{irf.VECM}
\alias{irf.TVAR}
\alias{irf.TVECM}
\title{Impulse response function}
\usage{
\method{irf}{linear}(
  x,
  impulse = NULL,
  response = NULL,
  n.ahead = 10,
  ortho = TRUE,
  cumulative = FALSE,
  boot = TRUE,
  ci = 0.95,
  runs = 100,
  seed = NULL,
  ...
)

\method{irf}{setar}(
  x,
  impulse = NULL,
  response = NULL,
  n.ahead = 10,
  ortho = TRUE,
  cumulative = FALSE,
  boot = TRUE,
  ci = 0.95,
  runs = 100,
  seed = NULL,
  regime = c("L", "M", "H"),
  ...
)

\method{irf}{ar}(
  x,
  impulse = NULL,
  response = NULL,
  n.ahead = 10,
  ortho = TRUE,
  cumulative = FALSE,
  boot = TRUE,
  ci = 0.95,
  runs = 100,
  seed = NULL,
  ...
)

\method{irf}{VAR}(
  x,
  impulse = NULL,
  response = NULL,
  n.ahead = 10,
  ortho = TRUE,
  cumulative = FALSE,
  boot = TRUE,
  ci = 0.95,
  runs = 100,
  seed = NULL,
  ...
)

\method{irf}{VECM}(
  x,
  impulse = NULL,
  response = NULL,
  n.ahead = 10,
  ortho = TRUE,
  cumulative = FALSE,
  boot = TRUE,
  ci = 0.95,
  runs = 100,
  seed = NULL,
  ...
)

\method{irf}{TVAR}(
  x,
  impulse = NULL,
  response = NULL,
  n.ahead = 10,
  ortho = TRUE,
  cumulative = FALSE,
  boot = TRUE,
  ci = 0.95,
  runs = 100,
  seed = NULL,
  regime = c("L", "M", "H"),
  ...
)

\method{irf}{TVECM}(
  x,
  impulse = NULL,
  response = NULL,
  n.ahead = 10,
  ortho = TRUE,
  cumulative = FALSE,
  boot = TRUE,
  ci = 0.95,
  runs = 100,
  seed = NULL,
  regime = c("L", "M", "H"),
  ...
)
}
\arguments{
\item{x}{Object of class \sQuote{\code{VAR}}; generated by
\command{lineVar()}, or object of class \sQuote{\code{VECM}}; generated
by\command{VECM()}.}

\item{impulse, response}{Not used!}

\item{n.ahead}{Integer specifying the steps.}

\item{ortho}{Logical, if \code{TRUE} (the default) the orthogonalised
impulse response coefficients are computed .}

\item{cumulative}{Logical, if \code{TRUE} the cumulated impulse response
coefficients are computed. The default value is false.}

\item{boot, ci, runs, seed}{Arguments for the bootstrap, see  \code{\link[vars]{irf.varest}}}

\item{...}{Currently not used.}

\item{regime}{For a setar model, which regime (L, M or H) to produce IRF for?}
}
\value{
A list of class \sQuote{\code{varirf}} see  \code{\link[vars]{irf.varest}}
}
\description{
Compute the impulse response coefficients (IRF) of a VAR(p) (or transformed VECM to VAR(p)) for
\code{n.ahead} steps.
For TVECM and TVAR model, argument \code{regime} offers regime-specific IRF.
}
\examples{

data(barry)

## For VAR
mod_var <- lineVar(barry, lag = 2)
irf(mod_var, impulse = "dolcan", response = c("dolcan", "cpiUSA", "cpiCAN"), boot =
FALSE)

## For VECM
mod_VECM <- VECM(barry, lag = 2, estim="ML", r=2)
irf(mod_VECM, impulse = "dolcan", response = c("dolcan", "cpiUSA", "cpiCAN"), boot =
FALSE)

}
\seealso{
\code{\link{plot}} for the plot method. \code{\link{lineVar}},
\code{\link{VECM}} for the models.
Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton University
Press, Princeton.

Lutkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
Analysis}, Springer, New York.
}
\author{
Matthieu Stigler
}
\keyword{regression}
